package net.wasamon.blokus.javarock.tools;



public class BlokusDuoPatternSymGen extends RomGenerator{
	
	public static final int MAX_NUM_OF_POINTS = 5;
	public static final int NUM_OF_PATTERNS = 8;
	
	public BlokusDuoPatternSymGen(int width, int num){
		super("BlokusPatternSymTable", "vhdl_block_pattern_sym_table", width, num);
	}
	
	private static String convBitVector(int v){
		String s = "00000000";
		s += Integer.toBinaryString(v);
		return s.substring(s.length()-8, s.length());
	}
	
	public static void main(String... args){
		String contents = "";
		String sep = "";
		for(int i = 'a'; i <= 'u'; i++){
			contents += sep + "\"" + convBitVector(i) + "\""; // 'a'
			sep = ", ";
			
		}
		BlokusDuoPatternSymGen gen = new BlokusDuoPatternSymGen(8, ('u'-'a'+1));
		gen.genVHDL(contents);
		gen.genJava("net.wasamon.blokus.javarock", contents);
		
	}
	

}
