package net.wasamon.blokus;

import java.util.Random;

import net.wasamon.blokus.javarock.tools.Player;
import net.wasamon.blokus.javarock.tools.Point;

public class TestRandomPlace {
	
	private static byte toHex(int v){
		if(v < 10){
			return (byte)(v + '0');
		}else{
			return (byte)((v-10) + 'a');
		}
	}
	
	public static void main(String... args) {

		Board b = new Board();
		BlokusGUI gui = new BlokusGUI(b);
		gui.initTestGUI();

		Player player = new Player();
		Random rnd = new Random();
		
		{
			Point[] p = player.decode((byte) 'a', (byte) '5', (byte) 'u', (byte) '0');
			for (int i = 0; i < p.length; i++) {
				b.put(Board.BLUE, p[i].x, p[i].y, 'u');
			}
		}
		
		{
			Point[] p = player.decode((byte) 'a', (byte) 'a', (byte) 'u', (byte) '0');
			for (int i = 0; i < p.length; i++) {
				b.put(Board.ORANGE, p[i].x, p[i].y, 'u');
			}
		}
		
		for(int i = 0; i < player.obj.length-1; i++){
			byte sym = (byte)('a' + player.obj.length - i - 2);
			{
				int tryCount = 0;
				while(true){
					int x = rnd.nextInt(Board.COLS);
					int y = rnd.nextInt(Board.ROWS);
					int r = rnd.nextInt(8);
					System.out.printf("%c: (%c, %c) %%%c\n", sym, toHex(x), toHex(y), toHex(r));
					Point[] p = player.decode(toHex(x), toHex(y), sym, toHex(r));
					if(b.valid(x, y, p, Board.BLUE)){
						for(int j = 0; j < p.length; j++){
							b.put(Board.BLUE, p[j].x, p[j].y, (char)sym);
						}
						break;
					}
					tryCount++;
					if(tryCount > 1000) break;
				}
				gui.update();
			}
			{
				int tryCount = 0;
				while(true){
					int x = rnd.nextInt(Board.COLS);
					int y = rnd.nextInt(Board.ROWS);
					int r = rnd.nextInt(8);
					System.out.printf("%c: (%c, %c) %%%c\n", sym, toHex(x), toHex(y), toHex(r));
					Point[] p = player.decode(toHex(x), toHex(y), sym, toHex(r));
					if(b.valid(x, y, p, Board.ORANGE)){
						for(int j = 0; j < p.length; j++){
							b.put(Board.ORANGE, p[j].x, p[j].y, (char)sym);
						}
						break;
					}
					tryCount++;
					if(tryCount > 1000) break;
				}
				gui.update();
			}
		}


	}

}
