package net.wasamon.blokus;

import net.wasamon.blokus.javarock.tools.Point;

public class Board {

	public static final int NONE = 0;
	public static final int BLUE = 1;
	public static final int ORANGE = 2;

	public static final int COLS = 14;
	public static final int ROWS = 14;

	private int[] map = new int[COLS * ROWS];
	private char[] sym = new char[COLS * ROWS];

	public void init() {
		for (int i = 0; i < map.length; i++) {
			map[i] = NONE;
		}
	}

	public void put(int c, int x, int y, char s) {
		map[y * COLS + x] = c;
		sym[y * COLS + x] = s;
	}

	public int get(int x, int y) {
		return map[y * COLS + x];
	}
	
	public char getSym(int x, int y){
		return sym[y * COLS + x];
	}
	
	private boolean isInside(Point[] points) {
		for(int i = 0; i < points.length; i++){
			if(points[i].x < 0 || points[i].y < 0 || points[i].x >= COLS || points[i].y >= ROWS){
				return false;
			}
		}
		return true;
	}

	private boolean isEmptyAll(Point[] points) {
		for (int i = 0; i < points.length; i++) {
			if (map[points[i].y * COLS + points[i].x] != NONE) {
				return false;
			}
		}
		return true;
	}

	private boolean isDuplicated(Point[] points, int c) {
		for (int i = 0; i < points.length; i++) {
			if(points[i].x >= 0 && points[i].y >= 0 && points[i].x < COLS && points[i].y < ROWS){
				if (map[points[i].y * COLS + points[i].x] == c) {
					return true;
				}
			}
		}
		return false;
	}

	private Point[] newTestPattern(Point[] points){
		Point[] p = new Point[points.length];
		for(int i = 0; i < points.length; i++){
			p[i] = new Point(points[i].x, points[i].y);
		}
		return p;
	}

	private boolean isEdgeSharing(Point[] points, int c){
		boolean flag0, flag1, flag2, flag3;
		{ // NORTH
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].y = p[i].y-1;
			}
			flag0 = isDuplicated(p, c);
		}
		{ // WEST
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].x = p[i].x-1;
			}
			flag1 = isDuplicated(p, c);
		}
		{ // EAST
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].x = p[i].x+1;
			}
			flag2 = isDuplicated(p, c);
		}
		{ // SOUTH
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].y = p[i].y+1;
			}
			flag3 = isDuplicated(p, c);
		}
		if(flag0 == true || flag1 == true || flag2 == true || flag3 == true){
			return true;
		}else{
			return false;
		}
	}

	private boolean isVertexSharing(Point[] points, int c){
		boolean flag0, flag1, flag2, flag3;
		{ // NORTH-WEST
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].y = p[i].y-1;
				p[i].x = p[i].x-1;
			}
			flag0 = isDuplicated(p, c);
		}
		{ // NORTH-EAST
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].y = p[i].y-1;
				p[i].x = p[i].x+1;
			}
			flag1 = isDuplicated(p, c);
		}
		{ // SOUTH-WEST
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].y = p[i].y+1;
				p[i].x = p[i].x-1;
			}
			flag2 = isDuplicated(p, c);
		}
		{ // SOUTH-EAST
			Point[] p = newTestPattern(points);
			for(int i = 0; i < p.length; i++){
				p[i].y = p[i].y+1;
				p[i].x = p[i].x+1;
			}
			flag3 = isDuplicated(p, c);
		}
		if(flag0 == true || flag1 == true || flag2 == true || flag3 == true){
			return true;
		}else{
			return false;
		}
	}


	public boolean valid(int x, int y, Point[] points, int c) {
		if (isInside(points) == false) { return false; } // must be inside
		if (isEmptyAll(points) == false) { return false; } // must be fit in empty space
		if (isEdgeSharing(points, c) == true) { return false; } // must not be shared edges with existing blocks
		if (isVertexSharing(points, c) == false) { return false; } // must be shared vertices with existing blocks
		return true;
	}

}
