library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
entity vhdl_block_pattern_table is
  generic (
    DEPTH : integer := 10;
    WIDTH : integer := 8 );

  port (
    clk   : in  std_logic;
    reset : in  std_logic;
    data_raddr : in  std_logic_vector(31 downto 0);
    data_rdata : out std_logic_vector(7 downto 0) );

end vhdl_block_pattern_table;

architecture RTL of vhdl_block_pattern_table is

  type rom_type is array (0 to 839) of std_logic_vector (WIDTH-1 downto 0);
  constant ROM: rom_type := (
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "11111111", "11111111", "11111111", "11111111",
  "00000000", "00000001", "11111111", "11111111", "11111111",
  "00000000", "00000001", "11111111", "11111111", "11111111",
  "00000000", "00111000", "11111111", "11111111", "11111111",
  "00000000", "00001000", "11111111", "11111111", "11111111",
  "00000000", "00000111", "11111111", "11111111", "11111111",
  "00000000", "00000111", "11111111", "11111111", "11111111",
  "00000000", "00001000", "11111111", "11111111", "11111111",
  "00000000", "00111000", "11111111", "11111111", "11111111",
  "00000000", "00000001", "00000111", "11111111", "11111111",
  "00000000", "00000001", "00000111", "11111111", "11111111",
  "00000000", "00111000", "00001000", "11111111", "11111111",
  "00000000", "00001000", "00111000", "11111111", "11111111",
  "00000000", "00000111", "00000001", "11111111", "11111111",
  "00000000", "00000111", "00000001", "11111111", "11111111",
  "00000000", "00001000", "00111000", "11111111", "11111111",
  "00000000", "00111000", "00001000", "11111111", "11111111",
  "00000000", "00000111", "00001000", "11111111", "11111111",
  "00000000", "00000111", "00111000", "11111111", "11111111",
  "00000000", "00001000", "00000001", "11111111", "11111111",
  "00000000", "00111000", "00000001", "11111111", "11111111",
  "00000000", "00000001", "00111000", "11111111", "11111111",
  "00000000", "00000001", "00001000", "11111111", "11111111",
  "00000000", "00111000", "00000111", "11111111", "11111111",
  "00000000", "00001000", "00000111", "11111111", "11111111",
  "00000000", "00000111", "00000001", "00000010", "11111111",
  "00000000", "00000111", "00000001", "00000010", "11111111",
  "00000000", "00001000", "00111000", "00110000", "11111111",
  "00000000", "00111000", "00001000", "00010000", "11111111",
  "00000000", "00000001", "00000111", "00000110", "11111111",
  "00000000", "00000001", "00000111", "00000110", "11111111",
  "00000000", "00111000", "00001000", "00010000", "11111111",
  "00000000", "00001000", "00111000", "00110000", "11111111",
  "00000000", "00000111", "00111001", "00000001", "11111111",
  "00000000", "00000111", "00001001", "00000001", "11111111",
  "00000000", "00001000", "00111111", "00111000", "11111111",
  "00000000", "00111000", "00001111", "00001000", "11111111",
  "00000000", "00000001", "00001111", "00000111", "11111111",
  "00000000", "00000001", "00111111", "00000111", "11111111",
  "00000000", "00111000", "00001001", "00001000", "11111111",
  "00000000", "00001000", "00111001", "00111000", "11111111",
  "00000000", "00000111", "00001000", "00000001", "11111111",
  "00000000", "00000111", "00111000", "00000001", "11111111",
  "00000000", "00001000", "00000001", "00111000", "11111111",
  "00000000", "00111000", "00000001", "00001000", "11111111",
  "00000000", "00000001", "00111000", "00000111", "11111111",
  "00000000", "00000001", "00001000", "00000111", "11111111",
  "00000000", "00111000", "00000111", "00001000", "11111111",
  "00000000", "00001000", "00000111", "00111000", "11111111",
  "00000000", "00001000", "00001001", "00000001", "11111111",
  "00000000", "00111000", "00111001", "00000001", "11111111",
  "00000000", "00000001", "00111001", "00111000", "11111111",
  "00000000", "00000001", "00001001", "00001000", "11111111",
  "00000000", "00111000", "00111111", "00000111", "11111111",
  "00000000", "00001000", "00001111", "00000111", "11111111",
  "00000000", "00000111", "00001111", "00001000", "11111111",
  "00000000", "00000111", "00111111", "00111000", "11111111",
  "00000000", "00111000", "00000001", "00001001", "11111111",
  "00000000", "00001000", "00000001", "00111001", "11111111",
  "00000000", "00000111", "00111000", "00111001", "11111111",
  "00000000", "00000111", "00001000", "00001001", "11111111",
  "00000000", "00001000", "00000111", "00111111", "11111111",
  "00000000", "00111000", "00000111", "00001111", "11111111",
  "00000000", "00000001", "00001000", "00001111", "11111111",
  "00000000", "00000001", "00111000", "00111111", "11111111",
  "00000000", "00000111", "00000110", "00000001", "00000010",
  "00000000", "00000111", "00000110", "00000001", "00000010",
  "00000000", "00001000", "00010000", "00111000", "00110000",
  "00000000", "00111000", "00110000", "00001000", "00010000",
  "00000000", "00000001", "00000010", "00000111", "00000110",
  "00000000", "00000001", "00000010", "00000111", "00000110",
  "00000000", "00111000", "00110000", "00001000", "00010000",
  "00000000", "00001000", "00010000", "00111000", "00110000",
  "00000000", "00000110", "00000111", "00000001", "00111001",
  "00000000", "00000110", "00000111", "00000001", "00001001",
  "00000000", "00010000", "00001000", "00111000", "00111111",
  "00000000", "00110000", "00111000", "00001000", "00001111",
  "00000000", "00000010", "00000001", "00000111", "00001111",
  "00000000", "00000010", "00000001", "00000111", "00111111",
  "00000000", "00110000", "00111000", "00001000", "00001001",
  "00000000", "00010000", "00001000", "00111000", "00111001",
  "00000000", "00000110", "00000111", "00111000", "00111001",
  "00000000", "00000110", "00000111", "00001000", "00001001",
  "00000000", "00010000", "00001000", "00000111", "00111111",
  "00000000", "00110000", "00111000", "00000111", "00001111",
  "00000000", "00000010", "00000001", "00001000", "00001111",
  "00000000", "00000010", "00000001", "00111000", "00111111",
  "00000000", "00110000", "00111000", "00000001", "00001001",
  "00000000", "00010000", "00001000", "00000001", "00111001",
  "00000000", "00000111", "00111000", "00111001", "00000001",
  "00000000", "00000111", "00001000", "00001001", "00000001",
  "00000000", "00001000", "00000111", "00111111", "00111000",
  "00000000", "00111000", "00000111", "00001111", "00001000",
  "00000000", "00000001", "00001000", "00001111", "00000111",
  "00000000", "00000001", "00111000", "00111111", "00000111",
  "00000000", "00111000", "00000001", "00001001", "00001000",
  "00000000", "00001000", "00000001", "00111001", "00111000",
  "00000000", "00111111", "00000111", "00111001", "00000001",
  "00000000", "00001111", "00000111", "00001001", "00000001",
  "00000000", "00001111", "00001000", "00111111", "00111000",
  "00000000", "00111111", "00111000", "00001111", "00001000",
  "00000000", "00001001", "00000001", "00001111", "00000111",
  "00000000", "00111001", "00000001", "00111111", "00000111",
  "00000000", "00111001", "00111000", "00001001", "00001000",
  "00000000", "00001001", "00001000", "00111001", "00111000",
  "00000000", "00000111", "00001000", "00000001", "00000010",
  "00000000", "00000111", "00111000", "00000001", "00000010",
  "00000000", "00001000", "00000001", "00111000", "00110000",
  "00000000", "00111000", "00000001", "00001000", "00010000",
  "00000000", "00000001", "00111000", "00000111", "00000110",
  "00000000", "00000001", "00001000", "00000111", "00000110",
  "00000000", "00111000", "00000111", "00001000", "00010000",
  "00000000", "00001000", "00000111", "00111000", "00110000",
  "00000000", "00000111", "00111001", "00000001", "00001001",
  "00000000", "00000111", "00001001", "00000001", "00111001",
  "00000000", "00001000", "00111111", "00111000", "00111001",
  "00000000", "00111000", "00001111", "00001000", "00001001",
  "00000000", "00000001", "00001111", "00000111", "00111111",
  "00000000", "00000001", "00111111", "00000111", "00001111",
  "00000000", "00111000", "00001001", "00001000", "00001111",
  "00000000", "00001000", "00111001", "00111000", "00111111",
  "00000000", "00000110", "00000111", "00001000", "00010000",
  "00000000", "00000110", "00000111", "00111000", "00110000",
  "00000000", "00010000", "00001000", "00000001", "00000010",
  "00000000", "00110000", "00111000", "00000001", "00000010",
  "00000000", "00000010", "00000001", "00111000", "00110000",
  "00000000", "00000010", "00000001", "00001000", "00010000",
  "00000000", "00110000", "00111000", "00000111", "00000110",
  "00000000", "00010000", "00001000", "00000111", "00000110",
  "00000000", "00111111", "00000111", "00001000", "00001001",
  "00000000", "00001111", "00000111", "00111000", "00111001",
  "00000000", "00001111", "00001000", "00000001", "00111001",
  "00000000", "00111111", "00111000", "00000001", "00001001",
  "00000000", "00001001", "00000001", "00111000", "00111111",
  "00000000", "00111001", "00000001", "00001000", "00001111",
  "00000000", "00111001", "00111000", "00000111", "00001111",
  "00000000", "00001001", "00001000", "00000111", "00111111",
  "00000000", "00111111", "00111000", "00001000", "00001001",
  "00000000", "00001111", "00001000", "00111000", "00111001",
  "00000000", "00001111", "00000111", "00000001", "00111001",
  "00000000", "00111111", "00000111", "00000001", "00001001",
  "00000000", "00001001", "00001000", "00111000", "00111111",
  "00000000", "00111001", "00111000", "00001000", "00001111",
  "00000000", "00111001", "00000001", "00000111", "00001111",
  "00000000", "00001001", "00000001", "00000111", "00111111",
  "00000000", "00111111", "00111000", "00001000", "00000001",
  "00000000", "00001111", "00001000", "00111000", "00000001",
  "00000000", "00001111", "00000111", "00000001", "00111000",
  "00000000", "00111111", "00000111", "00000001", "00001000",
  "00000000", "00001001", "00001000", "00111000", "00000111",
  "00000000", "00111001", "00111000", "00001000", "00000111",
  "00000000", "00111001", "00000001", "00000111", "00001000",
  "00000000", "00001001", "00000001", "00000111", "00111000",
  "00000000", "00000111", "00111000", "00001000", "00000001",
  "00000000", "00000111", "00001000", "00111000", "00000001",
  "00000000", "00001000", "00000111", "00000001", "00111000",
  "00000000", "00111000", "00000111", "00000001", "00001000",
  "00000000", "00000001", "00001000", "00111000", "00000111",
  "00000000", "00000001", "00111000", "00001000", "00000111",
  "00000000", "00111000", "00000001", "00000111", "00001000",
  "00000000", "00001000", "00000001", "00000111", "00111000"
  );  signal q : std_logic_vector(7 downto 0);
begin  -- RTL

  data_rdata <= q;

  process (clk)
  begin
    if clk'event and clk = '1' then
      q <= ROM(conv_integer(data_raddr(DEPTH-1 downto 0)));
    end if;
  end process;

end RTL;
