library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_signed.all;
entity net_wasamon_blokus_javarock_led is
  port (
    value_field_rdata_output_port : OUT std_logic_vector(31 downto 0);
    notify_method_busy : OUT std_logic;
    run_method_busy : OUT std_logic;
    value_field_rdata_input_strobe_port : IN std_logic;
    value_field_rdata_input_port : IN std_logic_vector(31 downto 0);
    run_method_request : IN std_logic;
    notify_method_request : IN std_logic;
    reset : IN std_logic;
    clk : IN std_logic
  );
end net_wasamon_blokus_javarock_led;

architecture RTL of net_wasamon_blokus_javarock_led is
  signal flag_field_wdata_reset : std_logic := '0';
  signal flag_field_wdata_reset_strobe : std_logic := '0';
  signal flag_field_wdata_writer_run_method_state : std_logic := '0';
  signal flag_field_wdata_writer_strobe_run_method_state : std_logic := '0';
  signal flag_field_wdata_writer_state_counter_run_run_8 : std_logic := '0';
  signal flag_field_wdata_writer_strobe_state_counter_run_run_8 : std_logic := '0';
  signal flag_field_wdata_writer_state_counter_run_run_12 : std_logic := '0';
  signal flag_field_wdata_writer_strobe_state_counter_run_run_12 : std_logic := '0';
  signal flag_field_rdata : std_logic := '0';
  signal flag_field_wdata : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset : std_logic := '0';
  signal this_wait_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_wait_method_request_field_rdata : std_logic := '0';
  signal this_wait_method_request_field_wdata : std_logic := '0';
  signal value_field_wdata_reset : std_logic_vector(31 downto 0) := conv_std_logic_vector(0, 31-0+1);
  signal value_field_wdata_reset_strobe : std_logic := '0';
  signal value_field_wdata_writer_run_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal value_field_wdata_writer_strobe_run_method_state : std_logic := '0';
  signal value_field_wdata_writer_state_counter_run_run_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal value_field_wdata_writer_strobe_state_counter_run_run_5 : std_logic := '0';
  signal value_field_wdata_writer_state_counter_run_run_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal value_field_wdata_writer_strobe_state_counter_run_run_9 : std_logic := '0';
  signal value_field_rdata : std_logic_vector(31 downto 0) := conv_std_logic_vector(0, 31-0+1);
  signal value_field_wdata : std_logic_vector(31 downto 0) := conv_std_logic_vector(0, 31-0+1);
  signal this_sleep_method_request_field_wdata_reset : std_logic := '0';
  signal this_sleep_method_request_field_wdata_reset_strobe : std_logic := '0';
  signal this_sleep_method_request_field_wdata_writer_state_counter_run_run_2 : std_logic := '0';
  signal this_sleep_method_request_field_wdata_writer_strobe_state_counter_run_run_2 : std_logic := '0';
  signal this_sleep_method_request_field_rdata : std_logic := '0';
  signal this_sleep_method_request_field_wdata : std_logic := '0';
  signal run_if_flag_run_4_run_2 : std_logic := '0';
  signal state_counter_sleep_sleep_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_wait_method_busy : std_logic := '0';
  signal state_counter_run_run_12 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_request : std_logic := '0';
  signal state_counter_run_run_10 : std_logic_vector(31 downto 0) := (others => '0');
  signal run_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal run_if_flag_run_7_run_5 : std_logic := '0';
  signal this_sleep_method_busy : std_logic := '0';
  signal wait_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal i_sleep_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_notify_method_busy : std_logic := '0';
  signal this_run_method_request : std_logic := '0';
  signal d_notify_flag : std_logic := '0';
  signal notify_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_wait_wait_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal sleep_method_state : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_run_run_9 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_sleep_call_state_counter_run_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_run_run_8 : std_logic_vector(31 downto 0) := (others => '0');
  signal run_if_flag_run_11_run_9 : std_logic := '0';
  signal state_counter_run_run_6 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_run_run_5 : std_logic_vector(31 downto 0) := (others => '0');
  signal notify_flag : std_logic := '0';
  signal state_counter_run_run_3 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_run_run_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_sleep_sleep_2 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_run_run_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal this_run_method_busy : std_logic := '0';
  signal state_counter_sleep_sleep_1 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_run_run_0 : std_logic_vector(31 downto 0) := (others => '0');
  signal state_counter_notify_notify_0 : std_logic_vector(31 downto 0) := (others => '0');
begin
  this_notify_method_request <= notify_method_request;
  notify_method_busy <= this_notify_method_busy;
  value_field_rdata_output_port <= conv_std_logic_vector(conv_integer(value_field_rdata), value_field_rdata_output_port'length);
  this_run_method_request <= run_method_request;
  run_method_busy <= this_run_method_busy;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        flag_field_wdata <= flag_field_wdata_reset;
      elsif (flag_field_wdata_reset_strobe = '1') then
        flag_field_wdata <= flag_field_wdata_reset;
      elsif (flag_field_wdata_writer_strobe_run_method_state = '1') then
        flag_field_wdata <= flag_field_wdata_writer_run_method_state;
      elsif (flag_field_wdata_writer_strobe_state_counter_run_run_8 = '1') then
        flag_field_wdata <= flag_field_wdata_writer_state_counter_run_run_8;
      elsif (flag_field_wdata_writer_strobe_state_counter_run_run_12 = '1') then
        flag_field_wdata <= flag_field_wdata_writer_state_counter_run_run_12;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        flag_field_wdata_reset_strobe <= '1';
      else
        flag_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(run_method_state) = 2) then
        flag_field_wdata_writer_strobe_run_method_state <= '1';
      else
        flag_field_wdata_writer_strobe_run_method_state <= '0';
      end if;
      if (conv_integer(state_counter_run_run_8) = 1) then
        flag_field_wdata_writer_strobe_state_counter_run_run_8 <= '1';
      else
        flag_field_wdata_writer_strobe_state_counter_run_run_8 <= '0';
      end if;
      if (conv_integer(state_counter_run_run_12) = 1) then
        flag_field_wdata_writer_strobe_state_counter_run_run_12 <= '1';
      else
        flag_field_wdata_writer_strobe_state_counter_run_run_12 <= '0';
      end if;
    end if;
  end process;
  flag_field_rdata <= flag_field_wdata_reset when (reset = '1') else
        flag_field_wdata_reset when (flag_field_wdata_reset_strobe = '1') else
        flag_field_wdata_writer_run_method_state when (flag_field_wdata_writer_strobe_run_method_state = '1') else
        flag_field_wdata_writer_state_counter_run_run_8 when (flag_field_wdata_writer_strobe_state_counter_run_run_8 = '1') else
        flag_field_wdata_writer_state_counter_run_run_12 when (flag_field_wdata_writer_strobe_state_counter_run_run_12 = '1') else
        flag_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      elsif (this_wait_method_request_field_wdata_reset_strobe = '1') then
        this_wait_method_request_field_wdata <= this_wait_method_request_field_wdata_reset;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_wait_method_request_field_wdata_reset_strobe <= '1';
      else
        this_wait_method_request_field_wdata_reset_strobe <= '0';
      end if;
    end if;
  end process;
  this_wait_method_request_field_rdata <= this_wait_method_request_field_wdata_reset when (reset = '1') else
        this_wait_method_request_field_wdata_reset when (this_wait_method_request_field_wdata_reset_strobe = '1') else
        this_wait_method_request_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        value_field_wdata <= value_field_wdata_reset;
      elsif (value_field_wdata_reset_strobe = '1') then
        value_field_wdata <= value_field_wdata_reset;
      elsif (value_field_wdata_writer_strobe_run_method_state = '1') then
        value_field_wdata <= value_field_wdata_writer_run_method_state;
      elsif (value_field_wdata_writer_strobe_state_counter_run_run_5 = '1') then
        value_field_wdata <= value_field_wdata_writer_state_counter_run_run_5;
      elsif (value_field_wdata_writer_strobe_state_counter_run_run_9 = '1') then
        value_field_wdata <= value_field_wdata_writer_state_counter_run_run_9;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        value_field_wdata_reset_strobe <= '1';
      else
        value_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(run_method_state) = 2) then
        value_field_wdata_writer_strobe_run_method_state <= '1';
      else
        value_field_wdata_writer_strobe_run_method_state <= '0';
      end if;
      if (conv_integer(state_counter_run_run_5) = 1) then
        value_field_wdata_writer_strobe_state_counter_run_run_5 <= '1';
      else
        value_field_wdata_writer_strobe_state_counter_run_run_5 <= '0';
      end if;
      if (conv_integer(state_counter_run_run_9) = 1) then
        value_field_wdata_writer_strobe_state_counter_run_run_9 <= '1';
      else
        value_field_wdata_writer_strobe_state_counter_run_run_9 <= '0';
      end if;
    end if;
  end process;
  value_field_rdata <= value_field_wdata_reset when (reset = '1') else
        value_field_wdata_reset when (value_field_wdata_reset_strobe = '1') else
        value_field_wdata_writer_run_method_state when (value_field_wdata_writer_strobe_run_method_state = '1') else
        value_field_wdata_writer_state_counter_run_run_5 when (value_field_wdata_writer_strobe_state_counter_run_run_5 = '1') else
        value_field_wdata_writer_state_counter_run_run_9 when (value_field_wdata_writer_strobe_state_counter_run_run_9 = '1') else
        value_field_wdata;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_sleep_method_request_field_wdata <= this_sleep_method_request_field_wdata_reset;
      elsif (this_sleep_method_request_field_wdata_reset_strobe = '1') then
        this_sleep_method_request_field_wdata <= this_sleep_method_request_field_wdata_reset;
      elsif (this_sleep_method_request_field_wdata_writer_strobe_state_counter_run_run_2 = '1') then
        this_sleep_method_request_field_wdata <= this_sleep_method_request_field_wdata_writer_state_counter_run_run_2;
      end if;
    end if;
  end process;
  process(clk)
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        this_sleep_method_request_field_wdata_reset_strobe <= '1';
      else
        this_sleep_method_request_field_wdata_reset_strobe <= '0';
      end if;
      if (conv_integer(state_counter_run_run_2) = 2 or conv_integer(state_counter_run_run_2) = 2) then
        this_sleep_method_request_field_wdata_writer_strobe_state_counter_run_run_2 <= '1';
      else
        this_sleep_method_request_field_wdata_writer_strobe_state_counter_run_run_2 <= '0';
      end if;
    end if;
  end process;
  this_sleep_method_request_field_rdata <= this_sleep_method_request_field_wdata_reset when (reset = '1') else
        this_sleep_method_request_field_wdata_reset when (this_sleep_method_request_field_wdata_reset_strobe = '1') else
        this_sleep_method_request_field_wdata_writer_state_counter_run_run_2 when (this_sleep_method_request_field_wdata_writer_strobe_state_counter_run_run_2 = '1') else
        this_sleep_method_request_field_wdata;
  process(clk) --notify
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        notify_flag <= '0';
        this_notify_method_busy <= '0';
        notify_method_state <= (others => '0');
        state_counter_notify_notify_0 <= (others => '0');
      else
        case conv_integer(notify_method_state) is
          when 0 =>
            if(this_notify_method_request = '1') then
              this_notify_method_busy <= '1';
              notify_method_state <= notify_method_state + 1;
            else
              this_notify_method_busy <= '0';
            end if;
          when 1 =>
            if(this_notify_method_request = '0') then
              notify_method_state <= notify_method_state + 1;
            end if;
          when 2 => 
            notify_flag <= '1';
            notify_method_state <= notify_method_state + 1;
          when 3 => 
            notify_flag <= '0';
            notify_method_state <= notify_method_state + 1;
          when 4 =>
            this_notify_method_busy <= '0';
            notify_method_state <= (others => '0');
          when others => notify_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --notify
  process(clk) --sleep
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_sleep_sleep_0 <= (others => '0');
        state_counter_sleep_sleep_1 <= (others => '0');
        i_sleep_1 <= (others => '0');
        state_counter_sleep_sleep_2 <= (others => '0');
        this_sleep_method_busy <= '0';
        sleep_method_state <= (others => '0');
      else
        case conv_integer(sleep_method_state) is
          when 0 =>
            if(this_sleep_method_request_field_rdata = '1') then
              this_sleep_method_busy <= '1';
              sleep_method_state <= sleep_method_state + 1;
            else
              this_sleep_method_busy <= '0';
            end if;
          when 1 =>
            if(this_sleep_method_request_field_rdata = '0') then
              sleep_method_state <= sleep_method_state + 1;
            end if;
          when 2 => 
            case conv_integer(state_counter_sleep_sleep_1) is
              when 0 => state_counter_sleep_sleep_1 <= state_counter_sleep_sleep_1 + 1;
              when 1 =>
                i_sleep_1 <= conv_std_logic_vector(0, i_sleep_1'length);
                state_counter_sleep_sleep_1 <= state_counter_sleep_sleep_1 + 1;
              when 2 =>
                if (conv_integer(i_sleep_1) < 10000000) then
                  state_counter_sleep_sleep_1 <= state_counter_sleep_sleep_1 + 1;
                  state_counter_sleep_sleep_2 <= conv_std_logic_vector(1, state_counter_sleep_sleep_2'length);
                else
                  sleep_method_state <= sleep_method_state + 1;
                  state_counter_sleep_sleep_1 <= (others => '0');
                end if;
              when 3 =>
                case conv_integer(state_counter_sleep_sleep_2) is
                  when 0 => state_counter_sleep_sleep_2 <= state_counter_sleep_sleep_2 + 1;
                  when 1 =>
                    state_counter_sleep_sleep_1 <= state_counter_sleep_sleep_1 + 1;
                    state_counter_sleep_sleep_2 <= (others => '0');
                  when others => state_counter_sleep_sleep_2 <= (others => '0');
                end case;
              when 4 =>
                  i_sleep_1 <= conv_std_logic_vector(conv_integer(i_sleep_1) + 1, i_sleep_1'length);
                  state_counter_sleep_sleep_1 <= conv_std_logic_vector(2, 32);
              when others => state_counter_sleep_sleep_1 <= (others => '0');
            end case;
          when 3 =>
            this_sleep_method_busy <= '0';
            sleep_method_state <= (others => '0');
          when others => sleep_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --sleep
  process(clk) --run
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        state_counter_run_run_0 <= (others => '0');
        state_counter_run_run_1 <= (others => '0');
        state_counter_run_run_2 <= (others => '0');
        state_counter_run_run_3 <= (others => '0');
        run_if_flag_run_4_run_2 <= '0';
        state_counter_run_run_5 <= (others => '0');
        state_counter_run_run_6 <= (others => '0');
        run_if_flag_run_7_run_5 <= '0';
        state_counter_run_run_8 <= (others => '0');
        state_counter_run_run_9 <= (others => '0');
        state_counter_run_run_10 <= (others => '0');
        run_if_flag_run_11_run_9 <= '0';
        state_counter_run_run_12 <= (others => '0');
        this_sleep_call_state_counter_run_2 <= (others => '0');
        this_sleep_call_state_counter_run_2 <= (others => '0');
        this_run_method_busy <= '0';
        run_method_state <= (others => '0');
        value_field_wdata_reset <= conv_std_logic_vector(0, 31-0+1);
        flag_field_wdata_reset <= '1';
        this_sleep_method_request_field_wdata_reset <= '0';
      else
        case conv_integer(run_method_state) is
          when 0 =>
            if(this_run_method_request = '1') then
              this_run_method_busy <= '1';
              run_method_state <= run_method_state + 1;
            else
              this_run_method_busy <= '0';
            end if;
          when 1 =>
            if(this_run_method_request = '0') then
              run_method_state <= run_method_state + 1;
            end if;
          when 2 => 
            value_field_wdata_writer_run_method_state <= conv_std_logic_vector(1, value_field_wdata'length);
            flag_field_wdata_writer_run_method_state <= '1';
            run_method_state <= run_method_state + 1;
          when 3 => 
            case conv_integer(state_counter_run_run_1) is
              when 0 => state_counter_run_run_1 <= state_counter_run_run_1 + 1;
              when 1 =>
                if (true) then
                  state_counter_run_run_1 <= state_counter_run_run_1 + 1;
                  state_counter_run_run_2 <= conv_std_logic_vector(1, state_counter_run_run_2'length);
                else
                  run_method_state <= run_method_state + 1;
                  state_counter_run_run_1 <= (others => '0');
                end if;
              when 2 =>
                case conv_integer(state_counter_run_run_2) is
                  when 0 => state_counter_run_run_2 <= state_counter_run_run_2 + 1;
                  when 1 =>
                    case conv_integer(state_counter_run_run_3) is
                      when 0 => state_counter_run_run_3 <= state_counter_run_run_3 + 1;
                      when 1 =>
                        if (flag_field_rdata = '1') then
                          run_if_flag_run_4_run_2 <= '1';
                          state_counter_run_run_5 <= conv_std_logic_vector(1, state_counter_run_run_5'length);
                        else
                          run_if_flag_run_4_run_2 <= '0';
                          state_counter_run_run_9 <= conv_std_logic_vector(1, state_counter_run_run_9'length);
                        end if;
                        state_counter_run_run_3 <= state_counter_run_run_3 + 1;
                      when 2 =>
                        if (run_if_flag_run_4_run_2 = '1') then
                          case conv_integer(state_counter_run_run_5) is
                            when 0 => state_counter_run_run_5 <= state_counter_run_run_5 + 1;
                            when 1 =>
                              value_field_wdata_writer_state_counter_run_run_5 <= conv_std_logic_vector(conv_integer(value_field_rdata(31 - 1 downto 0) & conv_std_logic_vector(0, 1)), value_field_wdata'length);
                              state_counter_run_run_5 <= state_counter_run_run_5 + 1;
                            when 2 =>
                              case conv_integer(state_counter_run_run_6) is
                                when 0 => state_counter_run_run_6 <= state_counter_run_run_6 + 1;
                                when 1 =>
                                  if (conv_integer(value_field_rdata) = 128) then
                                    run_if_flag_run_7_run_5 <= '1';
                                    state_counter_run_run_8 <= conv_std_logic_vector(1, state_counter_run_run_8'length);
                                  else
                                    run_if_flag_run_7_run_5 <= '0';
                                  end if;
                                  state_counter_run_run_6 <= state_counter_run_run_6 + 1;
                                when 2 =>
                                  if (run_if_flag_run_7_run_5 = '1') then
                                    case conv_integer(state_counter_run_run_8) is
                                      when 0 => state_counter_run_run_8 <= state_counter_run_run_8 + 1;
                                      when 1 =>
                                        flag_field_wdata_writer_state_counter_run_run_8 <= '0';
                                        state_counter_run_run_6 <= state_counter_run_run_6 + 1;
                                        state_counter_run_run_8 <= (others => '0');
                                      when others => state_counter_run_run_8 <= (others => '0');
                                    end case;
                                  else
                                    state_counter_run_run_6 <= state_counter_run_run_6 + 1;
                                  end if;
                                when 3 =>
                                  state_counter_run_run_6 <= (others => '0');
                                  state_counter_run_run_5 <= state_counter_run_run_5 + 1;
                                when others =>
                                  state_counter_run_run_6 <= (others => '0');
                              end case;
                            when 3 =>
                              state_counter_run_run_3 <= state_counter_run_run_3 + 1;
                              state_counter_run_run_5 <= (others => '0');
                            when others => state_counter_run_run_5 <= (others => '0');
                          end case;
                        else
                          case conv_integer(state_counter_run_run_9) is
                            when 0 => state_counter_run_run_9 <= state_counter_run_run_9 + 1;
                            when 1 =>
                              value_field_wdata_writer_state_counter_run_run_9 <= conv_std_logic_vector(conv_integer((31 downto (31-1+1) => value_field_rdata(31)) & value_field_rdata(31 downto 1)), value_field_wdata'length);
                              state_counter_run_run_9 <= state_counter_run_run_9 + 1;
                            when 2 =>
                              case conv_integer(state_counter_run_run_10) is
                                when 0 => state_counter_run_run_10 <= state_counter_run_run_10 + 1;
                                when 1 =>
                                  if (conv_integer(value_field_rdata) = 1) then
                                    run_if_flag_run_11_run_9 <= '1';
                                    state_counter_run_run_12 <= conv_std_logic_vector(1, state_counter_run_run_12'length);
                                  else
                                    run_if_flag_run_11_run_9 <= '0';
                                  end if;
                                  state_counter_run_run_10 <= state_counter_run_run_10 + 1;
                                when 2 =>
                                  if (run_if_flag_run_11_run_9 = '1') then
                                    case conv_integer(state_counter_run_run_12) is
                                      when 0 => state_counter_run_run_12 <= state_counter_run_run_12 + 1;
                                      when 1 =>
                                        flag_field_wdata_writer_state_counter_run_run_12 <= '1';
                                        state_counter_run_run_10 <= state_counter_run_run_10 + 1;
                                        state_counter_run_run_12 <= (others => '0');
                                      when others => state_counter_run_run_12 <= (others => '0');
                                    end case;
                                  else
                                    state_counter_run_run_10 <= state_counter_run_run_10 + 1;
                                  end if;
                                when 3 =>
                                  state_counter_run_run_10 <= (others => '0');
                                  state_counter_run_run_9 <= state_counter_run_run_9 + 1;
                                when others =>
                                  state_counter_run_run_10 <= (others => '0');
                              end case;
                            when 3 =>
                              state_counter_run_run_3 <= state_counter_run_run_3 + 1;
                              state_counter_run_run_9 <= (others => '0');
                            when others => state_counter_run_run_9 <= (others => '0');
                          end case;
                        end if;
                      when 3 =>
                        state_counter_run_run_3 <= (others => '0');
                        state_counter_run_run_2 <= state_counter_run_run_2 + 1;
                      when others =>
                        state_counter_run_run_3 <= (others => '0');
                    end case;
                  when 2 =>
                    case conv_integer(this_sleep_call_state_counter_run_2) is
                      when 0 =>
                        if (this_sleep_method_busy = '0') then
                          this_sleep_method_request_field_wdata_writer_state_counter_run_run_2 <= '1';
                          this_sleep_call_state_counter_run_2 <= conv_std_logic_vector(1, this_sleep_call_state_counter_run_2'length);
                        end if;
                      when 1 =>
                        this_sleep_method_request_field_wdata_writer_state_counter_run_run_2 <= '0';
                          this_sleep_call_state_counter_run_2 <= conv_std_logic_vector(2, this_sleep_call_state_counter_run_2'length);
                      when 2 =>
                        if (this_sleep_method_request_field_wdata = '0' and this_sleep_method_busy = '0') then
                          this_sleep_call_state_counter_run_2 <= (others => '0');
                          state_counter_run_run_2 <= state_counter_run_run_2 + 1;
                        end if;
                      when others => this_sleep_call_state_counter_run_2 <= (others => '0');
                    end case;
                  when 3 =>
                    state_counter_run_run_1 <= state_counter_run_run_1 + 1;
                    state_counter_run_run_2 <= (others => '0');
                  when others => state_counter_run_run_2 <= (others => '0');
                end case;
              when 3 =>
                state_counter_run_run_1 <= (others => '0');
              when others => state_counter_run_run_1 <= (others => '0');
            end case;
          when 4 =>
            this_run_method_busy <= '0';
            run_method_state <= (others => '0');
          when others => run_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --run
  process(clk) --wait
  begin
    if (clk'event and clk = '1') then
      if (reset = '1') then
        d_notify_flag <= '0';
        this_wait_method_busy <= '0';
        wait_method_state <= (others => '0');
        state_counter_wait_wait_0 <= (others => '0');
      else
        case conv_integer(wait_method_state) is
          when 0 =>
            if(this_wait_method_request_field_rdata = '1') then
              this_wait_method_busy <= '1';
              wait_method_state <= wait_method_state + 1;
            else
              this_wait_method_busy <= '0';
            end if;
          when 1 =>
            if(this_wait_method_request_field_rdata = '0') then
              wait_method_state <= wait_method_state + 1;
            end if;
          when 2 => 
            if (d_notify_flag = '0' and notify_flag = '1') then
              wait_method_state <= wait_method_state + 1;
            else
              d_notify_flag <= notify_flag;
            end if;
          when 3 =>
            this_wait_method_busy <= '0';
            wait_method_state <= (others => '0');
          when others => wait_method_state <= (others => '0');
        end case;
      end if;
    end if;
  end process; --wait
end RTL;
