package net.wasamon.blokus.javarock.test;

import java.util.Random;

import net.wasamon.blokus.javarock.BlokusBoard;

public class TestRandomPlace {
	
	public static void test(BlokusBoard b){
		Random rnd = new Random();
		
		TestUtil.setPattern(b, "55u0", BlokusBoard.BLUE);
		TestUtil.setPattern(b, "aau0", BlokusBoard.ORANGE);
		
		for(int i = 't'; i >= 'a'; i--){
			{
				int tryCount = 0;
				while(true){
					int x = rnd.nextInt(BlokusBoard.COLS);
					int y = rnd.nextInt(BlokusBoard.ROWS);
					int r = rnd.nextInt(8);
					System.out.printf("%c: (%c, %c) %%%c\n", i, TestUtil.toHex(x), TestUtil.toHex(y), TestUtil.toHex(r));
					if(b.isValid(x, y, BlokusBoard.BLUE, i-'a', r)){
						b.move(x, y, BlokusBoard.BLUE, i-'a', r);
						break;
					}
					tryCount++;
					if(tryCount > 1000) break;
				}
			}
			{
				int tryCount = 0;
				while(true){
					int x = rnd.nextInt(BlokusBoard.COLS);
					int y = rnd.nextInt(BlokusBoard.ROWS);
					int r = rnd.nextInt(8);
					System.out.printf("%c: (%c, %c) %%%c\n", i, TestUtil.toHex(x), TestUtil.toHex(y), TestUtil.toHex(r));
					if(b.isValid(x, y, BlokusBoard.ORANGE, i-'a', r)){
						b.move(x, y, BlokusBoard.ORANGE, i-'a', r);
						break;
					}
					tryCount++;
					if(tryCount > 1000) break;
				}
			}
		}
	}
	
	public static void main(String... args) {

		BlokusBoard b = new BlokusBoard();
		DebugGUI gui = new DebugGUI(b);
		gui.initTestGUI();
		test(b);
		gui.update();
		
	}

}
