package net.wasamon.blokus.javarock;

import net.wasamon.javarock.rt.unsynthesizable;

public class SimplePlayer {
	
	private final BlokusBoard board = new BlokusBoard();
	
	private int turnCode;
	private int myColor;
	private int opponentColor;
	
	public static final int COLS = 14;
	public static final int ROWS = 14;
	
	public static final int NONE = 0;
	public static final int BLUE = 1;
	public static final int ORANGE = 2;
	
	public void init(){
		board.init();
	}
	
	private int encode(int x, int y, int id, int rot){
		return ((x << 24) & 0xFF000000) + ((y << 16) & 0x00FF0000) + ((id << 8) & 0x0000FF00) + (rot & 0x000000FF); 
	}
	
	public void setTurnCode(int v){
		turnCode = v;
		if(v == 1){
			myColor = ORANGE;
			opponentColor = BLUE;
		}else{
			myColor = BLUE;
			opponentColor = ORANGE;
		}
	}
	
	public void setOpponentMove(int x, int y, int id, int rot){
		board.move(x, y, opponentColor, id, rot);
	}

	private int nextId;
	
	public int getFirstMoveCode(int x, int y){
		int id, rot;
		
		id = 'u'-'a';
		rot = 0;
		
		board.move(x, y, myColor, id, rot);
		nextId = id - 1 ;
		
		return encode(x, y, id, rot);
	}
	
	private int getNextMove1(){
		int code = 0;
		
		while(true){
			if(nextId < 0){ break; }
			for(int i = 0; i < COLS; i++){
				for(int j = 0; j < ROWS; j++){
					for(int k = 0; k < 8; k++){
						if(board.isValid(COLS - i - 1, ROWS - j - 1, myColor, nextId, k) == true){
							board.move(COLS - i - 1, ROWS - j - 1, myColor, nextId, k);
							code = encode(COLS - i -1, ROWS - j - 1, nextId, k);
							nextId = nextId - 1;
							return code;
						}
					}
				}
			}
			nextId = nextId - 1;
		}
		
		
		return -1;
	}
	
	private int getNextMove2(){
		int code = 0;
		
		while(true){
			if(nextId < 0){ break; }
			for(int i = 0; i < COLS; i++){
				for(int j = 0; j < ROWS; j++){
					for(int k = 0; k < 8; k++){
						if(board.isValid(i, j, myColor, nextId, k) == true){
							board.move(i, j, myColor, nextId, k);
							code = encode(i, j, nextId, k);
							nextId = nextId - 1;
							return code;
						}
					}
				}
			}
			
			nextId = nextId - 1;
		}
		
		return -1;
	}

	public int getNextMove(){
		
		if(nextId < 0){
			return -1;
		}
		
		if(turnCode == 1){
			return getNextMove1();
		}else{
			return getNextMove2();
		}
		
	}
	
	@unsynthesizable
	public BlokusBoard getBoard(){
		return board;
	}

}
