/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.javac.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.tools.JavaFileObject;
import openjdk.com.sun.tools.javac.code.Source;
import openjdk.com.sun.tools.javac.main.JavacOption;
import openjdk.com.sun.tools.javac.main.OptionName;
import openjdk.com.sun.tools.javac.main.RecognizedOptions;
import openjdk.com.sun.tools.javac.util.CloseableURLClassLoader;
import openjdk.com.sun.tools.javac.util.Context;
import openjdk.com.sun.tools.javac.util.JCDiagnostic;
import openjdk.com.sun.tools.javac.util.Log;
import openjdk.com.sun.tools.javac.util.Options;

public abstract class BaseFileManager {
    public Log log;
    protected Charset charset;
    protected Options options;
    protected String classLoaderClass;
    private static JavacOption[] javacFileManagerOptions = RecognizedOptions.getJavacFileManagerOptions(new RecognizedOptions.GrumpyHelper());
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    protected final Map<JavaFileObject, ContentCacheEntry> contentCache = new HashMap<JavaFileObject, ContentCacheEntry>();

    protected BaseFileManager(Charset charset) {
        this.charset = charset;
        this.byteBufferCache = new ByteBufferCache();
    }

    protected void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.classLoaderClass = this.options.get("procloader");
    }

    protected Source getSource() {
        String sourceName = this.options.get(OptionName.SOURCE);
        Source source = null;
        if (sourceName != null) {
            source = Source.lookup(sourceName);
        }
        return source != null ? source : Source.DEFAULT;
    }

    protected ClassLoader getClassLoader(URL[] urls) {
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        if (this.classLoaderClass != null) {
            try {
                Class<ClassLoader> loader = Class.forName(this.classLoaderClass).asSubclass(ClassLoader.class);
                Class[] constrArgTypes = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constr = loader.getConstructor(constrArgTypes);
                return constr.newInstance(urls, thisClassLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Closeable.class.isAssignableFrom(URLClassLoader.class)) {
            return new URLClassLoader(urls, thisClassLoader);
        }
        try {
            return new CloseableURLClassLoader(urls, thisClassLoader);
        }
        catch (Throwable throwable) {
            return new URLClassLoader(urls, thisClassLoader);
        }
    }

    public boolean handleOption(String current, Iterator<String> remaining) {
        JavacOption[] javacOptionArray = javacFileManagerOptions;
        int n = javacFileManagerOptions.length;
        int n2 = 0;
        while (n2 < n) {
            JavacOption o = javacOptionArray[n2];
            if (o.matches(current)) {
                if (o.hasArg() ? remaining.hasNext() && !o.process(this.options, current, remaining.next()) : !o.process(this.options, current)) {
                    return true;
                }
                throw new IllegalArgumentException(current);
            }
            ++n2;
        }
        return false;
    }

    public int isSupportedOption(String option) {
        JavacOption[] javacOptionArray = javacFileManagerOptions;
        int n = javacFileManagerOptions.length;
        int n2 = 0;
        while (n2 < n) {
            JavacOption o = javacOptionArray[n2];
            if (o.matches(option)) {
                return o.hasArg() ? 1 : 0;
            }
            ++n2;
        }
        return -1;
    }

    public abstract boolean isDefaultBootClassPath();

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    public String getEncodingName() {
        String encName = this.options.get(OptionName.ENCODING);
        if (encName == null) {
            return this.getDefaultEncodingName();
        }
        return encName;
    }

    public CharBuffer decode(ByteBuffer inbuf, boolean ignoreEncodingErrors) {
        CoderResult result;
        CharsetDecoder decoder;
        String encodingName = this.getEncodingName();
        try {
            decoder = this.getDecoder(encodingName, ignoreEncodingErrors);
        }
        catch (IllegalCharsetNameException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException e) {
            this.log.error("unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            if (!this.getSource().allowEncodingErrors()) {
                this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            } else {
                this.log.warning(new JCDiagnostic.SimpleDiagnosticPosition(dest.limit()), "illegal.char.for.encoding", this.charset == null ? encodingName : this.charset.name());
            }
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    public CharsetDecoder getDecoder(String encodingName, boolean ignoreEncodingErrors) {
        Charset cs = this.charset == null ? Charset.forName(encodingName) : this.charset;
        CharsetDecoder decoder = cs.newDecoder();
        CodingErrorAction action = ignoreEncodingErrors ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return decoder.onMalformedInput(action).onUnmappableCharacter(action);
    }

    public ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        int limit = in.available();
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = this.byteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    public void recycleByteBuffer(ByteBuffer bb) {
        this.byteBufferCache.put(bb);
    }

    public CharBuffer getCachedContent(JavaFileObject file) {
        ContentCacheEntry e = this.contentCache.get(file);
        if (e == null) {
            return null;
        }
        if (!e.isValid(file)) {
            this.contentCache.remove(file);
            return null;
        }
        return e.getValue();
    }

    public void cache(JavaFileObject file, CharBuffer cb) {
        this.contentCache.put(file, new ContentCacheEntry(file, cb));
    }

    public void flushCache(JavaFileObject file) {
        this.contentCache.remove(file);
    }

    public static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    protected static <T> T nullCheck(T o) {
        o.getClass();
        return o;
    }

    protected static <T> Collection<T> nullCheck(Collection<T> it) {
        for (T t : it) {
            t.getClass();
        }
        return it;
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int capacity) {
            if (capacity < 20480) {
                capacity = 20480;
            }
            ByteBuffer result = this.cached != null && this.cached.capacity() >= capacity ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
            this.cached = null;
            return result;
        }

        void put(ByteBuffer x) {
            this.cached = x;
        }
    }

    protected static class ContentCacheEntry {
        final long timestamp;
        final SoftReference<CharBuffer> ref;

        ContentCacheEntry(JavaFileObject file, CharBuffer cb) {
            this.timestamp = file.getLastModified();
            this.ref = new SoftReference<CharBuffer>(cb);
        }

        boolean isValid(JavaFileObject file) {
            return this.timestamp == file.getLastModified();
        }

        CharBuffer getValue() {
            return this.ref.get();
        }
    }
}

