/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openjdk.com.sun.tools.classfile.Attribute;
import openjdk.com.sun.tools.classfile.ClassReader;
import openjdk.com.sun.tools.classfile.ConstantPool;
import openjdk.com.sun.tools.classfile.ConstantPoolException;

public class Attributes
implements Iterable<Attribute> {
    public final Attribute[] attrs;
    public final Map<String, Attribute> map;

    Attributes(ClassReader cr) throws IOException {
        this.map = new HashMap<String, Attribute>();
        int attrs_count = cr.readUnsignedShort();
        this.attrs = new Attribute[attrs_count];
        int i = 0;
        while (i < attrs_count) {
            Attribute attr;
            this.attrs[i] = attr = Attribute.read(cr);
            try {
                this.map.put(attr.getName(cr.getConstantPool()), attr);
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
            ++i;
        }
    }

    public Attributes(ConstantPool constant_pool, Attribute[] attrs) {
        this.attrs = attrs;
        this.map = new HashMap<String, Attribute>();
        int i = 0;
        while (i < attrs.length) {
            Attribute attr = attrs[i];
            try {
                this.map.put(attr.getName(constant_pool), attr);
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return Arrays.asList(this.attrs).iterator();
    }

    public Attribute get(int index) {
        return this.attrs[index];
    }

    public Attribute get(String name) {
        return this.map.get(name);
    }

    public int getIndex(ConstantPool constant_pool, String name) {
        int i = 0;
        while (i < this.attrs.length) {
            Attribute attr = this.attrs[i];
            try {
                if (attr != null && attr.getName(constant_pool).equals(name)) {
                    return i;
                }
            }
            catch (ConstantPoolException constantPoolException) {
                // empty catch block
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        return this.attrs.length;
    }

    public int byteLength() {
        int length = 2;
        Attribute[] attributeArray = this.attrs;
        int n = this.attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute a = attributeArray[n2];
            length += a.byteLength();
            ++n2;
        }
        return length;
    }
}

