/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.io.IOException;
import openjdk.com.sun.tools.classfile.AttributeException;
import openjdk.com.sun.tools.classfile.ClassReader;
import openjdk.com.sun.tools.classfile.ConstantPool;

public class Annotation {
    public final int type_index;
    public final int num_element_value_pairs;
    public final element_value_pair[] element_value_pairs;

    Annotation(ClassReader cr) throws IOException, InvalidAnnotation {
        this.type_index = cr.readUnsignedShort();
        this.num_element_value_pairs = cr.readUnsignedShort();
        this.element_value_pairs = new element_value_pair[this.num_element_value_pairs];
        int i = 0;
        while (i < this.element_value_pairs.length) {
            this.element_value_pairs[i] = new element_value_pair(cr);
            ++i;
        }
    }

    public Annotation(ConstantPool constant_pool, int type_index, element_value_pair[] element_value_pairs) {
        this.type_index = type_index;
        this.num_element_value_pairs = element_value_pairs.length;
        this.element_value_pairs = element_value_pairs;
    }

    public int length() {
        int n = 4;
        element_value_pair[] element_value_pairArray = this.element_value_pairs;
        int n2 = this.element_value_pairs.length;
        int n3 = 0;
        while (n3 < n2) {
            element_value_pair pair = element_value_pairArray[n3];
            n += pair.length();
            ++n3;
        }
        return n;
    }

    public static class Annotation_element_value
    extends element_value {
        public final Annotation annotation_value;

        Annotation_element_value(ClassReader cr, int tag) throws IOException, InvalidAnnotation {
            super(tag);
            this.annotation_value = new Annotation(cr);
        }

        @Override
        public int length() {
            return this.annotation_value.length();
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitAnnotation(this, p);
        }
    }

    public static class Array_element_value
    extends element_value {
        public final int num_values;
        public final element_value[] values;

        Array_element_value(ClassReader cr, int tag) throws IOException, InvalidAnnotation {
            super(tag);
            this.num_values = cr.readUnsignedShort();
            this.values = new element_value[this.num_values];
            int i = 0;
            while (i < this.values.length) {
                this.values[i] = element_value.read(cr);
                ++i;
            }
        }

        @Override
        public int length() {
            int n = 2;
            int i = 0;
            while (i < this.values.length) {
                n += this.values[i].length();
                ++i;
            }
            return n;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitArray(this, p);
        }
    }

    public static class Class_element_value
    extends element_value {
        public final int class_info_index;

        Class_element_value(ClassReader cr, int tag) throws IOException {
            super(tag);
            this.class_info_index = cr.readUnsignedShort();
        }

        @Override
        public int length() {
            return 2;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitClass(this, p);
        }
    }

    public static class Enum_element_value
    extends element_value {
        public final int type_name_index;
        public final int const_name_index;

        Enum_element_value(ClassReader cr, int tag) throws IOException {
            super(tag);
            this.type_name_index = cr.readUnsignedShort();
            this.const_name_index = cr.readUnsignedShort();
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitEnum(this, p);
        }
    }

    static class InvalidAnnotation
    extends AttributeException {
        private static final long serialVersionUID = -4620480740735772708L;

        InvalidAnnotation(String msg) {
            super(msg);
        }
    }

    public static class Primitive_element_value
    extends element_value {
        public final int const_value_index;

        Primitive_element_value(ClassReader cr, int tag) throws IOException {
            super(tag);
            this.const_value_index = cr.readUnsignedShort();
        }

        @Override
        public int length() {
            return 2;
        }

        @Override
        public <R, P> R accept(element_value.Visitor<R, P> visitor, P p) {
            return visitor.visitPrimitive(this, p);
        }
    }

    public static abstract class element_value {
        public final int tag;

        public static element_value read(ClassReader cr) throws IOException, InvalidAnnotation {
            int tag = cr.readUnsignedByte();
            switch (tag) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 90: 
                case 115: {
                    return new Primitive_element_value(cr, tag);
                }
                case 101: {
                    return new Enum_element_value(cr, tag);
                }
                case 99: {
                    return new Class_element_value(cr, tag);
                }
                case 64: {
                    return new Annotation_element_value(cr, tag);
                }
                case 91: {
                    return new Array_element_value(cr, tag);
                }
            }
            throw new InvalidAnnotation("unrecognized tag: " + tag);
        }

        protected element_value(int tag) {
            this.tag = tag;
        }

        public abstract int length();

        public abstract <R, P> R accept(Visitor<R, P> var1, P var2);

        public static interface Visitor<R, P> {
            public R visitPrimitive(Primitive_element_value var1, P var2);

            public R visitEnum(Enum_element_value var1, P var2);

            public R visitClass(Class_element_value var1, P var2);

            public R visitAnnotation(Annotation_element_value var1, P var2);

            public R visitArray(Array_element_value var1, P var2);
        }
    }

    public static class element_value_pair {
        public final int element_name_index;
        public final element_value value;

        element_value_pair(ClassReader cr) throws IOException, InvalidAnnotation {
            this.element_name_index = cr.readUnsignedShort();
            this.value = element_value.read(cr);
        }

        public int length() {
            return 2 + this.value.length();
        }
    }
}

