/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockComponentInstance;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.StateMachineIface;
import net.wasamon.javarock.model.StateSignal;
import net.wasamon.javarock.model.vhdl.VHDLArrayPort;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.Manager;
import net.wasamon.javarock.tools.types.ComponentType;

public class VHDLMethodInvoke
extends VHDLStatement
implements VHDLItem,
StateMachineIface {
    private ComponentType type;
    final String methodName;
    final String instance;
    final VHDLModule m;
    final VHDLProcess process;
    final StateSignal STATE_SIG;
    final VHDLScopeIface scope;
    final ArrayList<VHDLExpr> args;
    private VHDLStatement assertRequest;
    private VHDLStatement deassertRequest;
    private ArrayList<VHDLStatement> passParamStmts = new ArrayList();

    public VHDLMethodInvoke(VHDLProcess process, VHDLScopeIface scope, String instance, String method, ArrayList<VHDLExpr> args) {
        this.process = process;
        this.scope = scope;
        this.m = process.module;
        this.methodName = method;
        this.instance = instance;
        this.args = args;
        this.STATE_SIG = new StateSignal(scope.addSignal((JavaRockType)VHDLTypeBuilder.getStdLogicVector((int)31, (int)0), (String)String.format((String)"%s_%s_call_state_counter", (Object[])new Object[]{instance, method})).name);
    }

    @Override
    public StateSignal get_state_sig() {
        return this.STATE_SIG;
    }

    @Override
    public String getStmtBody() {
        String str = "";
        str = String.format("[VHDLMethodInvoke@%x: process=%s module=%s name=%s instance=%s]", this.hashCode(), this.process, this.m, this.methodName, this.instance);
        return str;
    }

    private boolean isIndirectInvoke() {
        return this.instance.indexOf(46) > 0;
    }

    @Override
    public void connect() {
        if (!this.instance.equals("this")) {
            this.type = this.process.module.getComponentInstance(this.instance).getComponentType();
        } else {
            this.isIndirectInvoke();
        }
        String reqName = String.format("%s_%s_method_request", this.instance, this.methodName);
        if (this.scope.hasIdent(reqName)) {
            VHDLIdent req = this.scope.getIdent(reqName, VHDLExpr.TERM.RHS);
            this.process.addResetStmt((VHDLSignal)req.var);
        } else if (this.m.output.containsKey(reqName)) {
            this.process.addResetStmt(this.m.output.get(reqName));
        }
        if (this.instance.equals("this")) {
            return;
        }
        JavaRockComponentInstance inst = this.m.getComponentInstance(this.instance);
        JavaRockComponentIface component = inst.getComponentIface();
        for (VHDLPort port : component.getPortArrayList()) {
            if (port.dir != VHDLPort.Dir.IN) continue;
            port.getResetStmt();
        }
    }

    @Override
    public void link() {
        super.link();
        VHDLModule module = this.getModule();
        String calling = module.isThread() && this.methodName.equals("start") ? "run" : this.methodName;
        Iterator<VHDLSignal> method_args = module.search(calling).parameters().iterator();
        for (VHDLExpr expr : this.args) {
            VHDLSignal port = method_args.next();
            if (port instanceof VHDLArrayPort) {
                VHDLIdent lhs = this.scope.getIdent(String.valueOf(this.instance) + "_" + port.name + "_length", VHDLExpr.TERM.LHS);
                VHDLIdent rhs = this.scope.getIdent(String.valueOf(expr.getExprAsStr()) + "_length", VHDLExpr.TERM.RHS);
                this.m.combinations.add(new VHDLNonBlockAssignStmt(this.process, this.scope, lhs, (VHDLExpr)rhs, this));
                lhs = this.scope.getIdent(String.valueOf(this.instance) + "_" + port.name + "_rdata", VHDLExpr.TERM.LHS);
                rhs = this.scope.getIdent(String.valueOf(expr.getExprAsStr()) + "_rdata", VHDLExpr.TERM.RHS);
                this.m.combinations.add(new VHDLNonBlockAssignStmt(this.process, this.scope, lhs, (VHDLExpr)rhs, this));
                lhs = this.scope.getIdent(String.valueOf(expr.getExprAsStr()) + "_raddr", VHDLExpr.TERM.LHS);
                rhs = this.scope.getIdent(String.valueOf(this.instance) + "_" + port.name + "_raddr", VHDLExpr.TERM.RHS);
                this.m.combinations.add(new VHDLNonBlockAssignStmt(this.process, this.scope, lhs, (VHDLExpr)rhs, this));
                continue;
            }
            VHDLIdent ident = this.instance.equals("this") ? this.scope.getIdent(port.name, VHDLExpr.TERM.LHS) : this.scope.getIdent(String.format("%s_%s", this.instance, port.name), VHDLExpr.TERM.LHS);
            this.passParamStmts.add(new VHDLNonBlockAssignStmt(this.process, this.scope, ident, expr, this));
        }
        VHDLIdent req = this.scope.getIdent(String.format("%s_%s", this.instance, module.reqTable.get(calling)), VHDLExpr.TERM.LHS);
        this.assertRequest = new VHDLNonBlockAssignStmt(this.process, this.scope, req, (VHDLExpr)new VHDLLiteral(true), this);
        this.deassertRequest = new VHDLNonBlockAssignStmt(this.process, this.scope, req, (VHDLExpr)new VHDLLiteral(false), this);
    }

    private VHDLModule getModule() throws UnsupportedOperationException {
        if (this.type == null) {
            return this.m;
        }
        JavaRockComponentIface iface = Manager.INSTANCE.getComponentIface(this.type);
        if (!(iface instanceof VHDLModule)) {
            System.err.println("Method invocation is only supported by instances of VHDLModule");
            throw new UnsupportedOperationException();
        }
        return (VHDLModule)iface;
    }

    public void genParamPass(PrintWriter out, int offset, VHDLModule module) {
        for (VHDLStatement stmt : this.passParamStmts) {
            stmt.generate(out, offset + 4);
        }
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        boolean thread;
        String calling;
        VHDLModule module = this.getModule();
        if (module.isThread() && this.methodName.equals("start")) {
            calling = "run";
            thread = true;
        } else {
            calling = this.methodName;
            VHDLProcess callee = module.search(this.methodName);
            if (callee.isNoWait()) {
                System.out.printf("VHDLMethoInvoke::generate **WARN** %s is marked as @no_wait\n", this.methodName);
                thread = true;
            } else {
                thread = false;
            }
        }
        String req = String.format("%s_%s", this.instance, module.reqTable.get(calling));
        String busy = String.format("%s_%s", this.instance, module.busyTable.get(calling));
        if (module.search((String)calling).sequential) {
            this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
            this.writeln(out, "when 0 =>", offset + 2);
            this.writeln(out, String.format("if (%s = '0') then", this.scope.getIdent(busy, VHDLExpr.TERM.LHS).getExprAsStr()), offset + 4);
            this.assertRequest.generate(out, offset + 6);
            this.writeln(out, String.format("%s <= conv_std_logic_vector(%d, %s'length);", this.STATE_SIG.value(), 1, this.STATE_SIG.value()), offset + 6);
            this.writeln(out, "end if;", offset + 4);
            this.writeln(out, "when 1 =>", offset + 2);
            if (!thread) {
                this.genParamPass(out, offset, module);
            }
            this.deassertRequest.generate(out, offset + 4);
            this.writeln(out, String.format("%s <= conv_std_logic_vector(%d, %s'length);", this.STATE_SIG.value(), 2, this.STATE_SIG.value()), offset + 6);
            this.writeln(out, "when 2 =>", offset + 2);
            if (thread) {
                this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
                this.writeln(out, String.format("%s <= %s + 1;", this.scope.get_state_sig().value(), this.scope.get_state_sig().value()), offset + 4);
            } else {
                this.writeln(out, String.format("if (%s = '0' and %s = '0') then", this.scope.getIdent(req, VHDLExpr.TERM.LHS).getExprAsStr(), this.scope.getIdent(busy, VHDLExpr.TERM.LHS).getExprAsStr()), offset + 4);
                this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 6);
                this.writeln(out, String.format("%s <= %s + 1;", this.scope.get_state_sig().value(), this.scope.get_state_sig().value()), offset + 6);
                this.writeln(out, "end if;", offset + 4);
            }
            this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIG.value()), offset + 2);
            this.writeln(out, "end case;", offset);
        } else {
            this.genParamPass(out, offset, module);
        }
    }

    @Override
    public int state_count() {
        String calling;
        String string = calling = this.getModule().isThread() && this.methodName.equals("start") ? "run" : this.methodName;
        if (this.getModule().search((String)calling).sequential) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isStepNext() {
        String calling;
        String string = calling = this.getModule().isThread() && this.methodName.equals("start") ? "run" : this.methodName;
        return this.getModule().search((String)calling).sequential;
    }

    @Override
    public boolean isEndOfState() {
        String calling;
        String string = calling = this.getModule().isThread() && this.methodName.equals("start") ? "run" : this.methodName;
        return this.getModule().search((String)calling).sequential;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        return null;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        for (VHDLExpr expr : this.args) {
            ArrayList<VHDLIdent> l = expr.getSrcIdent();
            if (l == null) continue;
            list.addAll(expr.getSrcIdent());
        }
        return list;
    }
}

