/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.util.ArrayList;
import net.wasamon.javarock.libraries.BitVectorIface;
import net.wasamon.javarock.libraries.SimpleDualPortRamIface;
import net.wasamon.javarock.model.Pair;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLFixedArray;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNewArray;
import net.wasamon.javarock.model.vhdl.VHDLNewComponentInstance;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.StdLogic;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.tools.types.CompiledComponentType;

public class VHDLFieldArray
extends VHDLFixedArray
implements VHDLFieldSignal {
    private final ArrayList<Pair<VHDLScopeIface, VHDLStatement>> writers = new ArrayList();
    private final ArrayList<Pair<VHDLScopeIface, VHDLStatement>> readers = new ArrayList();

    public VHDLFieldArray(VHDLModule module, String name, VHDLArrayType type) {
        super(module, name, type);
    }

    public VHDLFieldArray(VHDLModule module, String name, VHDLArrayType type, VHDLExpr reset) {
        super(module, name, type, reset);
    }

    @Override
    public String addWriter(VHDLScopeIface scope, VHDLStatement stmt) {
        this.writers.add(new Pair<VHDLScopeIface, VHDLStatement>(scope, stmt));
        return "";
    }

    @Override
    public String addReader(VHDLScopeIface scope, VHDLStatement stmt) {
        this.readers.add(new Pair<VHDLScopeIface, VHDLStatement>(scope, stmt));
        return "";
    }

    @Override
    public String getReadSigName() {
        return this.name;
    }

    @Override
    public String getWriteSigName() {
        return this.name;
    }

    @Override
    public void link() {
        VHDLIdent id;
        super.link();
        for (Pair<VHDLScopeIface, VHDLStatement> w : this.writers) {
            id = this.module.getIdent(String.valueOf(this.name) + "_waddr", VHDLExpr.TERM.LHS);
            ((VHDLFieldSignal)((Object)id.var)).addWriter((VHDLScopeIface)w.fst, (VHDLStatement)w.snd);
            id = this.module.getIdent(String.valueOf(this.name) + "_we", VHDLExpr.TERM.LHS);
            ((VHDLFieldSignal)((Object)id.var)).addWriter((VHDLScopeIface)w.fst, (VHDLStatement)w.snd);
        }
        for (Pair<VHDLScopeIface, VHDLStatement> r : this.readers) {
            id = this.module.getIdent(String.valueOf(this.name) + "_raddr", VHDLExpr.TERM.LHS);
            ((VHDLFieldSignal)((Object)id.var)).addWriter((VHDLScopeIface)r.fst, (VHDLStatement)r.snd);
        }
    }

    @Override
    public void connect() {
        super.connect();
    }

    @Override
    public void initialize(VHDLNewArray expr) {
        if (this.atype.base instanceof StdLogicVector) {
            SimpleDualPortRamIface memory = new SimpleDualPortRamIface(new String[]{String.valueOf(this.atype.getDepth()), ((StdLogicVector)this.atype.getType()).getWidth()});
            CompiledComponentType type = new CompiledComponentType(memory);
            this.module.addComponent(type);
            VHDLNewComponentInstance instance = this.module.newComponentInstance(this.name, type, false, true);
            instance.setArgs(new String[]{String.valueOf(this.atype.getDepth()), String.valueOf(this.atype.getWidth())});
        } else if (this.atype.base instanceof StdLogic) {
            BitVectorIface memory = new BitVectorIface(new String[]{String.valueOf(this.atype.getDepth()), this.atype.getWidth()});
            CompiledComponentType type = new CompiledComponentType(memory);
            this.module.addComponent(type);
            VHDLNewComponentInstance instance = this.module.newComponentInstance(this.name, type, false, true);
            instance.setArgs(new String[]{String.valueOf(this.atype.getDepth()), this.atype.getWidth()});
        } else {
            throw new RuntimeException("VHDLFieldArray::initialize does not support such type: " + this.atype.base.getClass().getName());
        }
    }

    @Override
    public void setReadOnly(boolean flag) {
    }

    class FieldWriter {
        VHDLScopeIface scope;
        VHDLStatement stmt;

        public FieldWriter(VHDLScopeIface scope, VHDLStatement stmt) {
            this.scope = scope;
            this.stmt = stmt;
        }
    }
}

