/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLArrayPort;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLMethodReturnValueIdent;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLSignal;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLArrayType;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import net.wasamon.javarock.tools.types.InstancePointer;

public class ArrayRef
implements InstancePointer {
    final String name;
    final VHDLArrayType type;
    final VHDLModule owner;
    private PointingObject point;

    public ArrayRef(VHDLModule owner, VHDLArrayType type, String name) {
        this.owner = owner;
        this.type = type;
        this.name = name;
    }

    public void setPointTo(VHDLScopeIface scope, VHDLExpr expr) {
        this.point = new PointingObject();
        this.point.expr = expr;
        this.point.scope = scope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect() {
        if (!(this.type.base instanceof StdLogicVector)) throw new RuntimeException(String.format("ArrayRef: not yet supported to access array of %s[%s]", this.type.base, this.type.base.getClass()));
        if (this.point.expr instanceof VHDLIdent) {
            VHDLIdent id = (VHDLIdent)this.point.expr;
            if (!(id.var instanceof VHDLArrayPort)) throw new RuntimeException(String.format("ArrayRef: not yet supported to access array of %s[%s]", id.var, id.var.getClass()));
            VHDLArrayPort ap = (VHDLArrayPort)id.var;
            VHDLSignal raddr0 = this.owner.addSignal(String.valueOf(this.name) + "_raddr", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            this.owner.combinations.add(new VHDLNonBlockAssignStmt(null, null, ap.getIdent("raddr", VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(raddr0, VHDLExpr.TERM.RHS)));
            VHDLSignal rdata0 = this.owner.addSignal(String.valueOf(this.name) + "_rdata", (StdLogicVector)this.type.base, null, true, false);
            this.owner.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(rdata0, VHDLExpr.TERM.LHS), (VHDLExpr)ap.getIdent("rdata", VHDLExpr.TERM.RHS)));
            VHDLSignal len0 = this.owner.addSignal(String.valueOf(this.name) + "_length", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            this.owner.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(len0, VHDLExpr.TERM.LHS), (VHDLExpr)ap.getIdent("length", VHDLExpr.TERM.RHS)));
            return;
        } else {
            boolean cfr_ignored_0 = this.point.expr instanceof VHDLMethodReturnValueIdent;
        }
    }

    @Override
    public void link() {
        if (this.point.expr instanceof VHDLMethodReturnValueIdent) {
            VHDLMethodReturnValueIdent id = (VHDLMethodReturnValueIdent)this.point.expr;
            VHDLSignal raddr0 = this.owner.addSignal(String.valueOf(this.name) + "_raddr", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            VHDLSignal raddr1 = this.owner.addSignal(String.valueOf(id.name) + "_raddr", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            this.owner.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(raddr1, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(raddr0, VHDLExpr.TERM.RHS)));
            VHDLSignal rdata0 = this.owner.addSignal(String.valueOf(this.name) + "_rdata", (StdLogicVector)this.type.base, null, true, false);
            VHDLSignal rdata1 = this.owner.addSignal(String.valueOf(this.name) + "_rdata", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            this.owner.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(rdata0, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(rdata1, VHDLExpr.TERM.RHS)));
            VHDLSignal len0 = this.owner.addSignal(String.valueOf(this.name) + "_length", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            VHDLSignal len1 = this.owner.addSignal(String.valueOf(this.name) + "_length", VHDLTypeBuilder.getStdLogicVector(31, 0), null, true, false);
            this.owner.combinations.add(new VHDLNonBlockAssignStmt(null, null, new VHDLIdent(len0, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLIdent(len1, VHDLExpr.TERM.RHS)));
        }
    }

    @Override
    public VHDLModule owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public JavaRockType getType() {
        return this.type;
    }

    @Override
    public String getDefaultValue() {
        return null;
    }

    @Override
    public String getTypeAsStr() {
        return "<<ArrayRef : " + this.type.getTypeAsStr() + " >>";
    }

    class PointingObject {
        VHDLExpr expr;
        VHDLScopeIface scope;

        PointingObject() {
        }
    }
}

