/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.util.ArrayList;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;
import openjdk.com.sun.source.tree.Tree;

public class VHDLLiteral
extends VHDLExpr
implements VHDLItem {
    final String val;
    final JavaRockType type;

    public VHDLLiteral(boolean flag) {
        this.val = flag ? "'1'" : "'0'";
        this.type = VHDLTypeBuilder.getStdLogic();
    }

    public VHDLLiteral(int value) {
        this.val = String.valueOf(value);
        this.type = VHDLTypeBuilder.getInteger();
    }

    public VHDLLiteral(Object value, Tree.Kind kind) {
        switch (kind) {
            case CHAR_LITERAL: {
                this.val = String.valueOf((int)((Character)value).charValue());
                this.type = VHDLTypeBuilder.getInteger();
                break;
            }
            case BOOLEAN_LITERAL: {
                this.val = (Boolean)value != false ? "'1'" : "'0'";
                this.type = VHDLTypeBuilder.getStdLogic();
                break;
            }
            case INT_LITERAL: {
                this.val = value.toString();
                this.type = VHDLTypeBuilder.getInteger();
                break;
            }
            case NULL_LITERAL: {
                this.val = null;
                this.type = null;
                break;
            }
            case FLOAT_LITERAL: {
                this.val = String.format("%d", Float.floatToIntBits(Float.parseFloat(value.toString())));
                this.type = VHDLTypeBuilder.getStdLogic();
                break;
            }
            default: {
                this.val = value.toString();
                this.type = VHDLTypeBuilder.getLiteral();
            }
        }
    }

    @Override
    public JavaRockType getType() {
        return this.type;
    }

    @Override
    public String getExprAsStr() {
        return this.val;
    }

    @Override
    public void connect() {
    }

    @Override
    public void link() {
    }

    public String toString() {
        System.out.println("[VHDLLiteral] WARN:: using toString()");
        return this.val;
    }

    @Override
    public void addSensitivityList(VHDLProcess p) {
    }

    @Override
    public boolean isInteger() {
        return !(this.type instanceof StdLogicVector);
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        return null;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        return null;
    }

    @Override
    public boolean hasFixedBitWidth() {
        return this.type instanceof StdLogicVector;
    }
}

