/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLBlock;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLLiteral;
import net.wasamon.javarock.model.vhdl.VHDLMethodReturnValueIdent;
import net.wasamon.javarock.model.vhdl.VHDLNonBlockAssignStmt;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScope;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLStatement;
import net.wasamon.javarock.model.vhdl.type.VHDLTypeBuilder;

public class VHDLIf
extends VHDLScope
implements VHDLItem {
    public VHDLExpr cond;
    public VHDLStatement thenpart;
    public VHDLStatement elsepart;
    private final String flag;

    public VHDLIf(VHDLProcess process, VHDLScopeIface parent) {
        super(process, parent);
        this.flag = String.valueOf(process.base) + "_if_flag_" + process.getScopeID();
        parent.addSignal(VHDLTypeBuilder.getStdLogic(), this.flag);
    }

    private int genConditionPrepare(PrintWriter out, int offset) {
        int state_count = 1;
        boolean next_label = true;
        for (VHDLStatement s : this.statements) {
            if (next_label) {
                this.writeln(out, String.format("when %d =>", state_count), offset);
            }
            ++state_count;
            s.generate(out, offset + 2);
            next_label = s.isEndOfState();
        }
        return state_count;
    }

    @Override
    public String getStmtBody() {
        return "VHDLIf";
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        int state_count = 1;
        this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
        this.writeln(out, String.format("when 0 => %s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 2);
        state_count = this.genConditionPrepare(out, offset + 2);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        ++state_count;
        if (this.cond instanceof VHDLMethodReturnValueIdent) {
            this.writeln(out, String.format("if (%s = '1') then", this.cond.getExprAsStr()), offset + 4);
        } else {
            this.writeln(out, String.format("if (%s) then", this.cond.getExprAsStr()), offset + 4);
        }
        new VHDLNonBlockAssignStmt(this.process, this.parent, this.parent.getIdent(this.flag, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLLiteral(true)).generate(out, offset + 6);
        if (this.thenpart instanceof VHDLBlock && !this.process.isRaw()) {
            this.writeln(out, String.format("%s <= conv_std_logic_vector(1, %s'length);", ((VHDLBlock)this.thenpart).STATE_SIG.value(), ((VHDLBlock)this.thenpart).STATE_SIG.value()), offset + 6);
        }
        this.writeln(out, "else", offset + 4);
        new VHDLNonBlockAssignStmt(this.process, this.parent, this.parent.getIdent(this.flag, VHDLExpr.TERM.LHS), (VHDLExpr)new VHDLLiteral(false)).generate(out, offset + 6);
        if (this.elsepart instanceof VHDLBlock && !this.process.isRaw()) {
            this.writeln(out, String.format("%s <= conv_std_logic_vector(1, %s'length);", ((VHDLBlock)this.elsepart).STATE_SIG.value(), ((VHDLBlock)this.elsepart).STATE_SIG.value()), offset + 6);
        }
        this.writeln(out, "end if;", offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 4);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        ++state_count;
        this.writeln(out, String.format("if (%s = '1') then", this.parent.getIdent(this.flag, VHDLExpr.TERM.RHS).getExprAsStr()), offset + 4);
        this.thenpart.generate(out, offset + 6);
        if (!this.thenpart.isStepNext()) {
            this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 6);
        }
        this.writeln(out, "else", offset + 4);
        if (this.elsepart != null) {
            this.elsepart.generate(out, offset + 6);
            if (!this.elsepart.isStepNext()) {
                this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 6);
            }
        } else {
            this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 6);
        }
        this.writeln(out, "end if;", offset + 4);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        ++state_count;
        this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.parent.get_state_sig().value(), this.parent.get_state_sig().value()), offset + 4);
        this.writeln(out, "when others =>", offset + 2);
        this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
        this.writeln(out, "end case;", offset);
    }

    @Override
    public void connect() {
        this.cond.connect();
        this.thenpart.connect();
        if (this.elsepart != null) {
            this.elsepart.connect();
        }
        for (VHDLStatement s : this.statements) {
            s.connect();
        }
    }

    @Override
    public void link() {
        this.cond.link();
        this.thenpart.link();
        if (this.elsepart != null) {
            this.elsepart.link();
        }
        super.link();
        int label = 1;
        for (VHDLStatement s : this.statements) {
            s.link();
            s.setStateLabel(label);
            if (!s.isEndOfState()) continue;
            ++label;
        }
        if (!(this.thenpart instanceof VHDLBlock)) {
            this.thenpart.setStateLabel(2);
        }
        if (this.elsepart != null && !(this.elsepart instanceof VHDLBlock)) {
            this.elsepart.setStateLabel(2);
        }
    }

    @Override
    public boolean isStepNext() {
        return true;
    }

    @Override
    public boolean isEndOfState() {
        return true;
    }

    @Override
    public int state_count() {
        return 1;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l = this.cond.getDestIdent();
        if (l != null) {
            list.addAll(l);
        }
        if ((l = this.thenpart.getDestIdent()) != null) {
            list.addAll(l);
        }
        if (this.elsepart != null && (l = this.elsepart.getDestIdent()) != null) {
            list.addAll(l);
        }
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l = this.cond.getSrcIdent();
        if (l != null) {
            list.addAll(l);
        }
        if ((l = this.thenpart.getSrcIdent()) != null) {
            list.addAll(l);
        }
        if (this.elsepart != null && (l = this.elsepart.getSrcIdent()) != null) {
            list.addAll(l);
        }
        return list;
    }

    @Override
    public void optimize() {
        if (this.thenpart != null && this.thenpart instanceof VHDLScope) {
            ((VHDLScope)this.thenpart).optimize();
        }
        if (this.elsepart != null && this.elsepart instanceof VHDLScope) {
            ((VHDLScope)this.elsepart).optimize();
        }
    }
}

