/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.util.ArrayList;
import java.util.Collection;
import net.wasamon.javarock.libraries.VHDLSimpleLibrary;
import net.wasamon.javarock.model.JavaRockComponentIface;
import net.wasamon.javarock.model.JavaRockType;
import net.wasamon.javarock.model.vhdl.ArrayRef;
import net.wasamon.javarock.model.vhdl.VHDLArrayPort;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLFieldSignal;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLModule;
import net.wasamon.javarock.model.vhdl.VHDLPort;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.type.StdLogicVector;
import net.wasamon.javarock.tools.CompileState;
import net.wasamon.javarock.tools.Manager;
import net.wasamon.javarock.tools.types.ComponentType;

public class VHDLFieldAccess
extends VHDLExpr {
    final VHDLProcess p;
    final VHDLIdent ident;
    final String field;
    final String name;
    final VHDLScopeIface scope;
    private final ArrayList<VHDLProcess> sensitive = new ArrayList();
    private boolean field_signal_flag = false;

    public VHDLFieldAccess(VHDLProcess p, VHDLScopeIface scope, VHDLIdent ident, String field) {
        this.p = p;
        this.ident = ident;
        this.field = field;
        this.scope = scope;
        this.name = String.format("%s_%s", ident.getExprAsStr(), field);
    }

    @Override
    public void connect() {
        JavaRockComponentIface iface;
        JavaRockType t = this.getType();
        if (t instanceof ComponentType && (iface = ((ComponentType)t).getComponentIface()) instanceof VHDLModule) {
            VHDLModule m = (VHDLModule)((ComponentType)t).getComponentIface();
            VHDLIdent id = m.getIdent(this.field, VHDLExpr.TERM.RHS);
            if (id.var instanceof VHDLFieldSignal) {
                this.field_signal_flag = true;
            }
        }
    }

    @Override
    public void link() {
        for (VHDLProcess p0 : this.sensitive) {
            p0.addSensitive(this.getIdent(VHDLExpr.TERM.RHS));
        }
    }

    @Override
    public JavaRockType getType() {
        return this.ident.var.type;
    }

    public VHDLPort search(JavaRockComponentIface iface) {
        if (!Manager.INSTANCE.isCompileStatePass(CompileState.CONNECT)) {
            throw new RuntimeException("\n[Internal Error] VHDLFieldAccess::search must be called after CONNECT pass.\n");
        }
        Collection<VHDLPort> list = iface.getPortArrayList();
        for (VHDLPort port : list) {
            System.out.println(port);
        }
        return null;
    }

    public VHDLIdent getIdent(VHDLExpr.TERM t) {
        if (this.scope.hasIdent(this.name)) {
            return this.scope.getIdent(this.name, t);
        }
        JavaRockComponentIface iface = null;
        if (this.ident.var.type instanceof ArrayRef) {
            iface = ((ComponentType)((ArrayRef)this.ident.var.type).type.base).getComponentIface();
            throw new RuntimeException("cannot access field member of: " + this.ident + "%" + this.ident.var.type);
        }
        if (this.ident.var instanceof VHDLArrayPort) {
            return ((VHDLArrayPort)this.ident.var).getIdent(this.field, t);
        }
        if (this.ident.var.type instanceof ComponentType) {
            iface = ((ComponentType)this.ident.var.type).getComponentIface();
            if (iface instanceof VHDLSimpleLibrary) {
                if (this.scope.hasIdent(this.name)) {
                    return this.scope.getIdent(String.valueOf(this.name) + "_wdata", t);
                }
                if (t == VHDLExpr.TERM.LHS) {
                    return this.scope.getIdent(String.valueOf(this.name) + "_wdata", t);
                }
                return this.scope.getIdent(String.valueOf(this.name) + "_rdata", t);
            }
            if (t == VHDLExpr.TERM.RHS) {
                VHDLIdent id = this.scope.getIdent(String.valueOf(this.name) + "_field_rdata_output_port", t);
                return id;
            }
            throw new RuntimeException("not supported yet to write field of instance.");
        }
        throw new RuntimeException("cannot access field member of: " + this.ident + "%" + this.ident.var.type);
    }

    @Override
    public boolean hasFixedBitWidth() {
        VHDLIdent id = this.getIdent(VHDLExpr.TERM.RHS);
        return id.var.type instanceof StdLogicVector;
    }

    @Override
    public String getExprAsStr() {
        return this.getIdent(VHDLExpr.TERM.RHS).getExprAsStr();
    }

    @Override
    public void addSensitivityList(VHDLProcess p) {
        this.sensitive.add(p);
    }

    @Override
    public boolean isInteger() {
        return this.ident.isInteger();
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        list.add(this.ident);
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        list.add(this.ident);
        return list;
    }
}

