/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.util.ArrayList;
import java.util.List;
import openjdk.com.sun.tools.classfile.ConstantPool;
import openjdk.com.sun.tools.classfile.ConstantPoolException;
import openjdk.com.sun.tools.classfile.Descriptor;
import openjdk.com.sun.tools.classfile.Type;

public class Signature
extends Descriptor {
    private String sig;
    private int sigp;
    private Type type;

    public Signature(int index) {
        super(index);
    }

    public Type getType(ConstantPool constant_pool) throws ConstantPoolException {
        if (this.type == null) {
            this.type = this.parse(this.getValue(constant_pool));
        }
        return this.type;
    }

    @Override
    public int getParameterCount(ConstantPool constant_pool) throws ConstantPoolException {
        Type.MethodType m = (Type.MethodType)this.getType(constant_pool);
        return m.paramTypes.size();
    }

    @Override
    public String getParameterTypes(ConstantPool constant_pool) throws ConstantPoolException {
        Type.MethodType m = (Type.MethodType)this.getType(constant_pool);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String sep = "";
        for (Type type : m.paramTypes) {
            sb.append(sep);
            sb.append(type);
            sep = ", ";
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getReturnType(ConstantPool constant_pool) throws ConstantPoolException {
        Type.MethodType m = (Type.MethodType)this.getType(constant_pool);
        return m.returnType.toString();
    }

    @Override
    public String getFieldType(ConstantPool constant_pool) throws ConstantPoolException {
        return this.getType(constant_pool).toString();
    }

    private Type parse(String sig) {
        this.sig = sig;
        this.sigp = 0;
        List<Type.TypeParamType> typeParamTypes = null;
        if (sig.charAt(this.sigp) == '<') {
            typeParamTypes = this.parseTypeParamTypes();
        }
        if (sig.charAt(this.sigp) == '(') {
            List<Type> paramTypes = this.parseTypeSignatures(')');
            Type returnType = this.parseTypeSignature();
            ArrayList<Type> throwsTypes = null;
            while (this.sigp < sig.length() && sig.charAt(this.sigp) == '^') {
                ++this.sigp;
                if (throwsTypes == null) {
                    throwsTypes = new ArrayList<Type>();
                }
                throwsTypes.add(this.parseTypeSignature());
            }
            return new Type.MethodType(typeParamTypes, paramTypes, returnType, throwsTypes);
        }
        Type t = this.parseTypeSignature();
        if (typeParamTypes == null && this.sigp == sig.length()) {
            return t;
        }
        Type superclass = t;
        ArrayList<Type> superinterfaces = null;
        while (this.sigp < sig.length()) {
            if (superinterfaces == null) {
                superinterfaces = new ArrayList<Type>();
            }
            superinterfaces.add(this.parseTypeSignature());
        }
        return new Type.ClassSigType(typeParamTypes, superclass, superinterfaces);
    }

    private Type parseTypeSignature() {
        switch (this.sig.charAt(this.sigp)) {
            case 'B': {
                ++this.sigp;
                return new Type.SimpleType("byte");
            }
            case 'C': {
                ++this.sigp;
                return new Type.SimpleType("char");
            }
            case 'D': {
                ++this.sigp;
                return new Type.SimpleType("double");
            }
            case 'F': {
                ++this.sigp;
                return new Type.SimpleType("float");
            }
            case 'I': {
                ++this.sigp;
                return new Type.SimpleType("int");
            }
            case 'J': {
                ++this.sigp;
                return new Type.SimpleType("long");
            }
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case 'S': {
                ++this.sigp;
                return new Type.SimpleType("short");
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
            case 'V': {
                ++this.sigp;
                return new Type.SimpleType("void");
            }
            case 'Z': {
                ++this.sigp;
                return new Type.SimpleType("boolean");
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.parseTypeSignature());
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType();
            }
            case '+': {
                ++this.sigp;
                return new Type.WildcardType(Type.WildcardType.Kind.EXTENDS, this.parseTypeSignature());
            }
            case '-': {
                ++this.sigp;
                return new Type.WildcardType(Type.WildcardType.Kind.SUPER, this.parseTypeSignature());
            }
        }
        throw new IllegalStateException(this.debugInfo());
    }

    private List<Type> parseTypeSignatures(char term) {
        ++this.sigp;
        ArrayList<Type> types = new ArrayList<Type>();
        while (this.sig.charAt(this.sigp) != term) {
            types.add(this.parseTypeSignature());
        }
        ++this.sigp;
        return types;
    }

    private Type parseClassTypeSignature() {
        assert (this.sig.charAt(this.sigp) == 'L');
        ++this.sigp;
        return this.parseClassTypeSignatureRest();
    }

    private Type parseClassTypeSignatureRest() {
        char sigch;
        StringBuilder sb = new StringBuilder();
        List<Type> argTypes = null;
        Type.ClassType t = null;
        do {
            sigch = this.sig.charAt(this.sigp);
            switch (sigch) {
                case '<': {
                    argTypes = this.parseTypeSignatures('>');
                    break;
                }
                case '.': 
                case ';': {
                    ++this.sigp;
                    t = new Type.ClassType(t, sb.toString(), argTypes);
                    sb.setLength(0);
                    argTypes = null;
                    break;
                }
                default: {
                    ++this.sigp;
                    sb.append(sigch);
                }
            }
        } while (sigch != ';');
        return t;
    }

    private List<Type.TypeParamType> parseTypeParamTypes() {
        assert (this.sig.charAt(this.sigp) == '<');
        ++this.sigp;
        ArrayList<Type.TypeParamType> types = new ArrayList<Type.TypeParamType>();
        while (this.sig.charAt(this.sigp) != '>') {
            types.add(this.parseTypeParamType());
        }
        ++this.sigp;
        return types;
    }

    private Type.TypeParamType parseTypeParamType() {
        int sep = this.sig.indexOf(":", this.sigp);
        String name = this.sig.substring(this.sigp, sep);
        Type classBound = null;
        ArrayList<Type> interfaceBounds = null;
        this.sigp = sep + 1;
        if (this.sig.charAt(this.sigp) != ':') {
            classBound = this.parseTypeSignature();
        }
        while (this.sig.charAt(this.sigp) == ':') {
            ++this.sigp;
            if (interfaceBounds == null) {
                interfaceBounds = new ArrayList<Type>();
            }
            interfaceBounds.add(this.parseTypeSignature());
        }
        return new Type.TypeParamType(name, classBound, interfaceBounds);
    }

    private Type parseTypeVariableSignature() {
        ++this.sigp;
        int sep = this.sig.indexOf(59, this.sigp);
        Type.SimpleType t = new Type.SimpleType(this.sig.substring(this.sigp, sep));
        this.sigp = sep + 1;
        return t;
    }

    private String debugInfo() {
        return String.valueOf(this.sig.substring(0, this.sigp)) + "!" + this.sig.charAt(this.sigp) + "!" + this.sig.substring(this.sigp + 1);
    }
}

