/*
 * Decompiled with CFR 0.152.
 */
package openjdk.com.sun.tools.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import openjdk.com.sun.tools.classfile.AccessFlags;
import openjdk.com.sun.tools.classfile.Annotation;
import openjdk.com.sun.tools.classfile.AnnotationDefault_attribute;
import openjdk.com.sun.tools.classfile.Attribute;
import openjdk.com.sun.tools.classfile.Attributes;
import openjdk.com.sun.tools.classfile.BootstrapMethods_attribute;
import openjdk.com.sun.tools.classfile.CharacterRangeTable_attribute;
import openjdk.com.sun.tools.classfile.ClassFile;
import openjdk.com.sun.tools.classfile.Code_attribute;
import openjdk.com.sun.tools.classfile.CompilationID_attribute;
import openjdk.com.sun.tools.classfile.ConstantPool;
import openjdk.com.sun.tools.classfile.ConstantValue_attribute;
import openjdk.com.sun.tools.classfile.DefaultAttribute;
import openjdk.com.sun.tools.classfile.Deprecated_attribute;
import openjdk.com.sun.tools.classfile.Descriptor;
import openjdk.com.sun.tools.classfile.EnclosingMethod_attribute;
import openjdk.com.sun.tools.classfile.Exceptions_attribute;
import openjdk.com.sun.tools.classfile.Field;
import openjdk.com.sun.tools.classfile.InnerClasses_attribute;
import openjdk.com.sun.tools.classfile.LineNumberTable_attribute;
import openjdk.com.sun.tools.classfile.LocalVariableTable_attribute;
import openjdk.com.sun.tools.classfile.LocalVariableTypeTable_attribute;
import openjdk.com.sun.tools.classfile.Method;
import openjdk.com.sun.tools.classfile.RuntimeInvisibleAnnotations_attribute;
import openjdk.com.sun.tools.classfile.RuntimeInvisibleParameterAnnotations_attribute;
import openjdk.com.sun.tools.classfile.RuntimeVisibleAnnotations_attribute;
import openjdk.com.sun.tools.classfile.RuntimeVisibleParameterAnnotations_attribute;
import openjdk.com.sun.tools.classfile.Signature_attribute;
import openjdk.com.sun.tools.classfile.SourceDebugExtension_attribute;
import openjdk.com.sun.tools.classfile.SourceFile_attribute;
import openjdk.com.sun.tools.classfile.SourceID_attribute;
import openjdk.com.sun.tools.classfile.StackMapTable_attribute;
import openjdk.com.sun.tools.classfile.StackMap_attribute;
import openjdk.com.sun.tools.classfile.Synthetic_attribute;

public class ClassWriter {
    protected ClassFile classFile;
    protected ClassOutputStream out;
    protected AttributeWriter attributeWriter = new AttributeWriter();
    protected ConstantPoolWriter constantPoolWriter = new ConstantPoolWriter();

    public ClassWriter() {
        this.out = new ClassOutputStream();
    }

    public void write(ClassFile classFile, File f) throws IOException {
        FileOutputStream f_out = new FileOutputStream(f);
        try {
            this.write(classFile, f_out);
        }
        finally {
            f_out.close();
        }
    }

    public void write(ClassFile classFile, OutputStream s) throws IOException {
        this.classFile = classFile;
        this.out.reset();
        this.write();
        this.out.writeTo(s);
    }

    protected void write() throws IOException {
        this.writeHeader();
        this.writeConstantPool();
        this.writeAccessFlags(this.classFile.access_flags);
        this.writeClassInfo();
        this.writeFields();
        this.writeMethods();
        this.writeAttributes(this.classFile.attributes);
    }

    protected void writeHeader() {
        this.out.writeInt(this.classFile.magic);
        this.out.writeShort(this.classFile.minor_version);
        this.out.writeShort(this.classFile.major_version);
    }

    protected void writeAccessFlags(AccessFlags flags) {
        this.out.writeShort(flags.flags);
    }

    protected void writeAttributes(Attributes attributes) {
        int size = attributes.size();
        this.out.writeShort(size);
        for (Attribute attr : attributes) {
            this.attributeWriter.write(attr, this.out);
        }
    }

    protected void writeClassInfo() {
        this.out.writeShort(this.classFile.this_class);
        this.out.writeShort(this.classFile.super_class);
        int[] interfaces = this.classFile.interfaces;
        this.out.writeShort(interfaces.length);
        int[] nArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.out.writeShort(i);
            ++n2;
        }
    }

    protected void writeDescriptor(Descriptor d) {
        this.out.writeShort(d.index);
    }

    protected void writeConstantPool() {
        ConstantPool pool = this.classFile.constant_pool;
        int size = pool.size();
        this.out.writeShort(size);
        for (ConstantPool.CPInfo cpInfo : pool.entries()) {
            this.constantPoolWriter.write(cpInfo, this.out);
        }
    }

    protected void writeFields() throws IOException {
        Field[] fields = this.classFile.fields;
        this.out.writeShort(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            this.writeField(f);
            ++n2;
        }
    }

    protected void writeField(Field f) throws IOException {
        this.writeAccessFlags(f.access_flags);
        this.out.writeShort(f.name_index);
        this.writeDescriptor(f.descriptor);
        this.writeAttributes(f.attributes);
    }

    protected void writeMethods() throws IOException {
        Method[] methods = this.classFile.methods;
        this.out.writeShort(methods.length);
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            this.writeMethod(m);
            ++n2;
        }
    }

    protected void writeMethod(Method m) throws IOException {
        this.writeAccessFlags(m.access_flags);
        this.out.writeShort(m.name_index);
        this.writeDescriptor(m.descriptor);
        this.writeAttributes(m.attributes);
    }

    protected static class AnnotationWriter
    implements Annotation.element_value.Visitor<Void, ClassOutputStream> {
        protected AnnotationWriter() {
        }

        public void write(Annotation[] annos, ClassOutputStream out) {
            out.writeShort(annos.length);
            Annotation[] annotationArray = annos;
            int n = annos.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                this.write(anno, out);
                ++n2;
            }
        }

        public void write(Annotation anno, ClassOutputStream out) {
            out.writeShort(anno.type_index);
            out.writeShort(anno.element_value_pairs.length);
            Annotation.element_value_pair[] element_value_pairArray = anno.element_value_pairs;
            int n = anno.element_value_pairs.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation.element_value_pair p = element_value_pairArray[n2];
                this.write(p, out);
                ++n2;
            }
        }

        public void write(Annotation.element_value_pair pair, ClassOutputStream out) {
            out.writeShort(pair.element_name_index);
            this.write(pair.value, out);
        }

        public void write(Annotation.element_value ev, ClassOutputStream out) {
            out.writeByte(ev.tag);
            ev.accept(this, out);
        }

        @Override
        public Void visitPrimitive(Annotation.Primitive_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.const_value_index);
            return null;
        }

        @Override
        public Void visitEnum(Annotation.Enum_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.type_name_index);
            out.writeShort(ev.const_name_index);
            return null;
        }

        @Override
        public Void visitClass(Annotation.Class_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.class_info_index);
            return null;
        }

        @Override
        public Void visitAnnotation(Annotation.Annotation_element_value ev, ClassOutputStream out) {
            this.write(ev.annotation_value, out);
            return null;
        }

        @Override
        public Void visitArray(Annotation.Array_element_value ev, ClassOutputStream out) {
            out.writeShort(ev.num_values);
            Annotation.element_value[] element_valueArray = ev.values;
            int n = ev.values.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation.element_value v = element_valueArray[n2];
                this.write(v, out);
                ++n2;
            }
            return null;
        }
    }

    protected static class AttributeWriter
    implements Attribute.Visitor<Void, ClassOutputStream> {
        protected ClassOutputStream sharedOut = new ClassOutputStream();
        protected AnnotationWriter annotationWriter = new AnnotationWriter();
        protected StackMapTableWriter stackMapWriter;

        protected AttributeWriter() {
        }

        public void write(Attributes attributes, ClassOutputStream out) {
            int size = attributes.size();
            out.writeShort(size);
            for (Attribute a : attributes) {
                this.write(a, out);
            }
        }

        public void write(Attribute attr, ClassOutputStream out) {
            out.writeShort(attr.attribute_name_index);
            this.sharedOut.reset();
            attr.accept(this, this.sharedOut);
            out.writeInt(this.sharedOut.size());
            this.sharedOut.writeTo(out);
        }

        @Override
        public Void visitDefault(DefaultAttribute attr, ClassOutputStream out) {
            out.write(attr.info, 0, attr.info.length);
            return null;
        }

        @Override
        public Void visitAnnotationDefault(AnnotationDefault_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.default_value, out);
            return null;
        }

        @Override
        public Void visitBootstrapMethods(BootstrapMethods_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.bootstrap_method_specifiers.length);
            BootstrapMethods_attribute.BootstrapMethodSpecifier[] bootstrapMethodSpecifierArray = attr.bootstrap_method_specifiers;
            int n = attr.bootstrap_method_specifiers.length;
            int n2 = 0;
            while (n2 < n) {
                BootstrapMethods_attribute.BootstrapMethodSpecifier bsm = bootstrapMethodSpecifierArray[n2];
                out.writeShort(bsm.bootstrap_method_ref);
                int bsm_args_count = bsm.bootstrap_arguments.length;
                out.writeShort(bsm_args_count);
                int[] nArray = bsm.bootstrap_arguments;
                int n3 = bsm.bootstrap_arguments.length;
                int n4 = 0;
                while (n4 < n3) {
                    int i = nArray[n4];
                    out.writeShort(i);
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public Void visitCharacterRangeTable(CharacterRangeTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.character_range_table.length);
            CharacterRangeTable_attribute.Entry[] entryArray = attr.character_range_table;
            int n = attr.character_range_table.length;
            int n2 = 0;
            while (n2 < n) {
                CharacterRangeTable_attribute.Entry e = entryArray[n2];
                this.writeCharacterRangeTableEntry(e, out);
                ++n2;
            }
            return null;
        }

        protected void writeCharacterRangeTableEntry(CharacterRangeTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.end_pc);
            out.writeInt(entry.character_range_start);
            out.writeInt(entry.character_range_end);
            out.writeShort(entry.flags);
        }

        @Override
        public Void visitCode(Code_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.max_stack);
            out.writeShort(attr.max_locals);
            out.writeInt(attr.code.length);
            out.write(attr.code, 0, attr.code.length);
            out.writeShort(attr.exception_table.length);
            Code_attribute.Exception_data[] exception_dataArray = attr.exception_table;
            int n = attr.exception_table.length;
            int n2 = 0;
            while (n2 < n) {
                Code_attribute.Exception_data e = exception_dataArray[n2];
                this.writeExceptionTableEntry(e, out);
                ++n2;
            }
            new AttributeWriter().write(attr.attributes, out);
            return null;
        }

        protected void writeExceptionTableEntry(Code_attribute.Exception_data exception_data, ClassOutputStream out) {
            out.writeShort(exception_data.start_pc);
            out.writeShort(exception_data.end_pc);
            out.writeShort(exception_data.handler_pc);
            out.writeShort(exception_data.catch_type);
        }

        @Override
        public Void visitCompilationID(CompilationID_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.compilationID_index);
            return null;
        }

        @Override
        public Void visitConstantValue(ConstantValue_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.constantvalue_index);
            return null;
        }

        @Override
        public Void visitDeprecated(Deprecated_attribute attr, ClassOutputStream out) {
            return null;
        }

        @Override
        public Void visitEnclosingMethod(EnclosingMethod_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.class_index);
            out.writeShort(attr.method_index);
            return null;
        }

        @Override
        public Void visitExceptions(Exceptions_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.exception_index_table.length);
            int[] nArray = attr.exception_index_table;
            int n = attr.exception_index_table.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                out.writeShort(i);
                ++n2;
            }
            return null;
        }

        @Override
        public Void visitInnerClasses(InnerClasses_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.classes.length);
            InnerClasses_attribute.Info[] infoArray = attr.classes;
            int n = attr.classes.length;
            int n2 = 0;
            while (n2 < n) {
                InnerClasses_attribute.Info info = infoArray[n2];
                this.writeInnerClassesInfo(info, out);
                ++n2;
            }
            return null;
        }

        protected void writeInnerClassesInfo(InnerClasses_attribute.Info info, ClassOutputStream out) {
            out.writeShort(info.inner_class_info_index);
            out.writeShort(info.outer_class_info_index);
            out.writeShort(info.inner_name_index);
            this.writeAccessFlags(info.inner_class_access_flags, out);
        }

        @Override
        public Void visitLineNumberTable(LineNumberTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.line_number_table.length);
            LineNumberTable_attribute.Entry[] entryArray = attr.line_number_table;
            int n = attr.line_number_table.length;
            int n2 = 0;
            while (n2 < n) {
                LineNumberTable_attribute.Entry e = entryArray[n2];
                this.writeLineNumberTableEntry(e, out);
                ++n2;
            }
            return null;
        }

        protected void writeLineNumberTableEntry(LineNumberTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.line_number);
        }

        @Override
        public Void visitLocalVariableTable(LocalVariableTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.local_variable_table.length);
            LocalVariableTable_attribute.Entry[] entryArray = attr.local_variable_table;
            int n = attr.local_variable_table.length;
            int n2 = 0;
            while (n2 < n) {
                LocalVariableTable_attribute.Entry e = entryArray[n2];
                this.writeLocalVariableTableEntry(e, out);
                ++n2;
            }
            return null;
        }

        protected void writeLocalVariableTableEntry(LocalVariableTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.length);
            out.writeShort(entry.name_index);
            out.writeShort(entry.descriptor_index);
            out.writeShort(entry.index);
        }

        @Override
        public Void visitLocalVariableTypeTable(LocalVariableTypeTable_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.local_variable_table.length);
            LocalVariableTypeTable_attribute.Entry[] entryArray = attr.local_variable_table;
            int n = attr.local_variable_table.length;
            int n2 = 0;
            while (n2 < n) {
                LocalVariableTypeTable_attribute.Entry e = entryArray[n2];
                this.writeLocalVariableTypeTableEntry(e, out);
                ++n2;
            }
            return null;
        }

        protected void writeLocalVariableTypeTableEntry(LocalVariableTypeTable_attribute.Entry entry, ClassOutputStream out) {
            out.writeShort(entry.start_pc);
            out.writeShort(entry.length);
            out.writeShort(entry.name_index);
            out.writeShort(entry.signature_index);
            out.writeShort(entry.index);
        }

        @Override
        public Void visitRuntimeVisibleAnnotations(RuntimeVisibleAnnotations_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.annotations, out);
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleAnnotations(RuntimeInvisibleAnnotations_attribute attr, ClassOutputStream out) {
            this.annotationWriter.write(attr.annotations, out);
            return null;
        }

        @Override
        public Void visitRuntimeVisibleParameterAnnotations(RuntimeVisibleParameterAnnotations_attribute attr, ClassOutputStream out) {
            out.writeByte(attr.parameter_annotations.length);
            Annotation[][] annotationArray = attr.parameter_annotations;
            int n = attr.parameter_annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] annos = annotationArray[n2];
                this.annotationWriter.write(annos, out);
                ++n2;
            }
            return null;
        }

        @Override
        public Void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisibleParameterAnnotations_attribute attr, ClassOutputStream out) {
            out.writeByte(attr.parameter_annotations.length);
            Annotation[][] annotationArray = attr.parameter_annotations;
            int n = attr.parameter_annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation[] annos = annotationArray[n2];
                this.annotationWriter.write(annos, out);
                ++n2;
            }
            return null;
        }

        @Override
        public Void visitSignature(Signature_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.signature_index);
            return null;
        }

        @Override
        public Void visitSourceDebugExtension(SourceDebugExtension_attribute attr, ClassOutputStream out) {
            out.write(attr.debug_extension, 0, attr.debug_extension.length);
            return null;
        }

        @Override
        public Void visitSourceFile(SourceFile_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.sourcefile_index);
            return null;
        }

        @Override
        public Void visitSourceID(SourceID_attribute attr, ClassOutputStream out) {
            out.writeShort(attr.sourceID_index);
            return null;
        }

        @Override
        public Void visitStackMap(StackMap_attribute attr, ClassOutputStream out) {
            if (this.stackMapWriter == null) {
                this.stackMapWriter = new StackMapTableWriter();
            }
            out.writeShort(attr.entries.length);
            StackMap_attribute.stack_map_frame[] stack_map_frameArray = attr.entries;
            int n = attr.entries.length;
            int n2 = 0;
            while (n2 < n) {
                StackMap_attribute.stack_map_frame f = stack_map_frameArray[n2];
                this.stackMapWriter.write(f, out);
                ++n2;
            }
            return null;
        }

        @Override
        public Void visitStackMapTable(StackMapTable_attribute attr, ClassOutputStream out) {
            if (this.stackMapWriter == null) {
                this.stackMapWriter = new StackMapTableWriter();
            }
            out.writeShort(attr.entries.length);
            StackMapTable_attribute.stack_map_frame[] stack_map_frameArray = attr.entries;
            int n = attr.entries.length;
            int n2 = 0;
            while (n2 < n) {
                StackMapTable_attribute.stack_map_frame f = stack_map_frameArray[n2];
                this.stackMapWriter.write(f, out);
                ++n2;
            }
            return null;
        }

        @Override
        public Void visitSynthetic(Synthetic_attribute attr, ClassOutputStream out) {
            return null;
        }

        protected void writeAccessFlags(AccessFlags flags, ClassOutputStream p) {
            this.sharedOut.writeShort(flags.flags);
        }
    }

    protected static class ClassOutputStream
    extends ByteArrayOutputStream {
        private DataOutputStream d = new DataOutputStream(this);

        public void writeByte(int value) {
            try {
                this.d.writeByte(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeShort(int value) {
            try {
                this.d.writeShort(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeInt(int value) {
            try {
                this.d.writeInt(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeLong(long value) {
            try {
                this.d.writeLong(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeFloat(float value) {
            try {
                this.d.writeFloat(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeDouble(double value) {
            try {
                this.d.writeDouble(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeUTF(String value) {
            try {
                this.d.writeUTF(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeTo(ClassOutputStream s) {
            try {
                super.writeTo(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static class ConstantPoolWriter
    implements ConstantPool.Visitor<Integer, ClassOutputStream> {
        protected ConstantPoolWriter() {
        }

        protected int write(ConstantPool.CPInfo info, ClassOutputStream out) {
            out.writeByte(info.getTag());
            return info.accept(this, out);
        }

        @Override
        public Integer visitClass(ConstantPool.CONSTANT_Class_info info, ClassOutputStream out) {
            out.writeShort(info.name_index);
            return 1;
        }

        @Override
        public Integer visitDouble(ConstantPool.CONSTANT_Double_info info, ClassOutputStream out) {
            out.writeDouble(info.value);
            return 2;
        }

        @Override
        public Integer visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, ClassOutputStream out) {
            this.writeRef(info, out);
            return 1;
        }

        @Override
        public Integer visitFloat(ConstantPool.CONSTANT_Float_info info, ClassOutputStream out) {
            out.writeFloat(info.value);
            return 1;
        }

        @Override
        public Integer visitInteger(ConstantPool.CONSTANT_Integer_info info, ClassOutputStream out) {
            out.writeInt(info.value);
            return 1;
        }

        @Override
        public Integer visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, ClassOutputStream out) {
            this.writeRef(info, out);
            return 1;
        }

        @Override
        public Integer visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, ClassOutputStream out) {
            out.writeShort(info.bootstrap_method_attr_index);
            out.writeShort(info.name_and_type_index);
            return 1;
        }

        @Override
        public Integer visitLong(ConstantPool.CONSTANT_Long_info info, ClassOutputStream out) {
            out.writeLong(info.value);
            return 2;
        }

        @Override
        public Integer visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, ClassOutputStream out) {
            out.writeShort(info.name_index);
            out.writeShort(info.type_index);
            return 1;
        }

        @Override
        public Integer visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, ClassOutputStream out) {
            out.writeByte(info.reference_kind.tag);
            out.writeShort(info.reference_index);
            return 1;
        }

        @Override
        public Integer visitMethodType(ConstantPool.CONSTANT_MethodType_info info, ClassOutputStream out) {
            out.writeShort(info.descriptor_index);
            return 1;
        }

        @Override
        public Integer visitMethodref(ConstantPool.CONSTANT_Methodref_info info, ClassOutputStream out) {
            return this.writeRef(info, out);
        }

        @Override
        public Integer visitString(ConstantPool.CONSTANT_String_info info, ClassOutputStream out) {
            out.writeShort(info.string_index);
            return 1;
        }

        @Override
        public Integer visitUtf8(ConstantPool.CONSTANT_Utf8_info info, ClassOutputStream out) {
            out.writeUTF(info.value);
            return 1;
        }

        protected Integer writeRef(ConstantPool.CPRefInfo info, ClassOutputStream out) {
            out.writeShort(info.class_index);
            out.writeShort(info.name_and_type_index);
            return 1;
        }
    }

    protected static class StackMapTableWriter
    implements StackMapTable_attribute.stack_map_frame.Visitor<Void, ClassOutputStream> {
        protected StackMapTableWriter() {
        }

        public void write(StackMapTable_attribute.stack_map_frame frame, ClassOutputStream out) {
            out.write(frame.frame_type);
            frame.accept(this, out);
        }

        @Override
        public Void visit_same_frame(StackMapTable_attribute.same_frame frame, ClassOutputStream p) {
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame(StackMapTable_attribute.same_locals_1_stack_item_frame frame, ClassOutputStream out) {
            this.writeVerificationTypeInfo(frame.stack[0], out);
            return null;
        }

        @Override
        public Void visit_same_locals_1_stack_item_frame_extended(StackMapTable_attribute.same_locals_1_stack_item_frame_extended frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            this.writeVerificationTypeInfo(frame.stack[0], out);
            return null;
        }

        @Override
        public Void visit_chop_frame(StackMapTable_attribute.chop_frame frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            return null;
        }

        @Override
        public Void visit_same_frame_extended(StackMapTable_attribute.same_frame_extended frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            return null;
        }

        @Override
        public Void visit_append_frame(StackMapTable_attribute.append_frame frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            StackMapTable_attribute.verification_type_info[] verification_type_infoArray = frame.locals;
            int n = frame.locals.length;
            int n2 = 0;
            while (n2 < n) {
                StackMapTable_attribute.verification_type_info l = verification_type_infoArray[n2];
                this.writeVerificationTypeInfo(l, out);
                ++n2;
            }
            return null;
        }

        @Override
        public Void visit_full_frame(StackMapTable_attribute.full_frame frame, ClassOutputStream out) {
            out.writeShort(frame.offset_delta);
            out.writeShort(frame.locals.length);
            StackMapTable_attribute.verification_type_info[] verification_type_infoArray = frame.locals;
            int n = frame.locals.length;
            int n2 = 0;
            while (n2 < n) {
                StackMapTable_attribute.verification_type_info l = verification_type_infoArray[n2];
                this.writeVerificationTypeInfo(l, out);
                ++n2;
            }
            out.writeShort(frame.stack.length);
            verification_type_infoArray = frame.stack;
            n = frame.stack.length;
            n2 = 0;
            while (n2 < n) {
                StackMapTable_attribute.verification_type_info s = verification_type_infoArray[n2];
                this.writeVerificationTypeInfo(s, out);
                ++n2;
            }
            return null;
        }

        protected void writeVerificationTypeInfo(StackMapTable_attribute.verification_type_info info, ClassOutputStream out) {
            out.write(info.tag);
            switch (info.tag) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    StackMapTable_attribute.Object_variable_info o = (StackMapTable_attribute.Object_variable_info)info;
                    out.writeShort(o.cpool_index);
                    break;
                }
                case 8: {
                    StackMapTable_attribute.Uninitialized_variable_info u = (StackMapTable_attribute.Uninitialized_variable_info)info;
                    out.writeShort(u.offset);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }
}

