/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLBlock;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLMethodReturnValueIdent;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScope;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLStatement;

public class VHDLWhile
extends VHDLScope
implements VHDLItem {
    public VHDLExpr cond;
    public VHDLStatement body;

    public VHDLWhile(VHDLProcess process, VHDLScopeIface parent) {
        super(process, parent);
    }

    private int genConditionPrepare(PrintWriter out, int offset) {
        int state_count = 1;
        for (VHDLStatement s : this.statements) {
            this.writeln(out, String.format("when %d =>", state_count), offset + 2);
            ++state_count;
            s.generate(out, offset);
        }
        return state_count;
    }

    @Override
    public String getStmtBody() {
        return "<<VHDLWhile>>";
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
        this.writeln(out, String.format("when 0 => %s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 2);
        int state_count = this.genConditionPrepare(out, offset + 2);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        ++state_count;
        if (this.cond instanceof VHDLMethodReturnValueIdent) {
            this.writeln(out, String.format("if (%s = '1') then", this.cond.getExprAsStr()), offset + 4);
        } else {
            this.writeln(out, String.format("if (%s) then", this.cond.getExprAsStr()), offset + 4);
        }
        this.writeln(out, String.format("%s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 6);
        if (this.body instanceof VHDLBlock && !this.process.isRaw()) {
            this.writeln(out, String.format("%s <= conv_std_logic_vector(1, %s'length);", ((VHDLBlock)this.body).STATE_SIG.value(), ((VHDLBlock)this.body).STATE_SIG.value()), offset + 6);
        }
        this.writeln(out, "else", offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.parent.get_state_sig().value(), this.parent.get_state_sig().value()), offset + 6);
        this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 6);
        this.writeln(out, "end if;", offset + 4);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        ++state_count;
        this.body.generate(out, offset + 4);
        if (this.body.isEndOfState()) {
            this.writeln(out, String.format("when %d =>", state_count), offset + 2);
            ++state_count;
        }
        this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 4);
        this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIG.value()), offset + 2);
        this.writeln(out, "end case;", offset);
    }

    @Override
    public void connect() {
        this.cond.connect();
        this.body.connect();
        for (VHDLStatement s : this.statements) {
            s.connect();
        }
    }

    @Override
    public void link() {
        super.link();
        this.cond.link();
        this.body.link();
        int cnt = 1;
        for (VHDLStatement s : this.statements) {
            s.link();
            s.setStateLabel(cnt);
            if (!s.isEndOfState()) continue;
            ++cnt;
        }
    }

    @Override
    public int state_count() {
        return 1;
    }

    @Override
    public boolean isStepNext() {
        return true;
    }

    @Override
    public boolean isEndOfState() {
        return true;
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l = this.cond.getDestIdent();
        if (l != null) {
            list.addAll(l);
        }
        if ((l = this.body.getDestIdent()) != null) {
            list.addAll(l);
        }
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        ArrayList<VHDLIdent> l = this.cond.getSrcIdent();
        if (l != null) {
            list.addAll(l);
        }
        if ((l = this.body.getSrcIdent()) != null) {
            list.addAll(l);
        }
        return list;
    }

    @Override
    public void optimize() {
        if (this.body != null && this.body instanceof VHDLScope) {
            ((VHDLScope)this.body).optimize();
        }
    }
}

