/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.javarock.model.vhdl;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.wasamon.javarock.model.vhdl.VHDLBlock;
import net.wasamon.javarock.model.vhdl.VHDLExpr;
import net.wasamon.javarock.model.vhdl.VHDLIdent;
import net.wasamon.javarock.model.vhdl.VHDLItem;
import net.wasamon.javarock.model.vhdl.VHDLProcess;
import net.wasamon.javarock.model.vhdl.VHDLScope;
import net.wasamon.javarock.model.vhdl.VHDLScopeIface;
import net.wasamon.javarock.model.vhdl.VHDLStatement;

public class VHDLFor
extends VHDLScope
implements VHDLItem {
    public VHDLStatement body;
    public VHDLExpr cond;
    public final ArrayList<VHDLStatement> init = new ArrayList();
    public final ArrayList<VHDLStatement> step = new ArrayList();

    public VHDLFor(VHDLProcess process, VHDLScopeIface parent) {
        super(process, parent);
    }

    @Override
    public void connect() {
        this.body.connect();
        this.cond.connect();
        for (VHDLStatement stmt : this.init) {
            stmt.connect();
        }
        for (VHDLStatement stmt : this.step) {
            stmt.connect();
        }
    }

    @Override
    public void link() {
        this.body.link();
        this.cond.link();
        for (VHDLStatement stmt : this.init) {
            stmt.link();
        }
        int cnt = 1;
        for (VHDLStatement stmt : this.step) {
            stmt.link();
            stmt.setStateLabel(cnt);
            if (!stmt.isEndOfState()) continue;
            ++cnt;
        }
    }

    @Override
    public int state_count() {
        return 1;
    }

    @Override
    public boolean isStepNext() {
        return true;
    }

    @Override
    public boolean isEndOfState() {
        return true;
    }

    private int genConditionPrepare(PrintWriter out, int offset) {
        int state_count = 1;
        for (VHDLStatement s : this.statements) {
            this.writeln(out, String.format("when %d =>", state_count), offset);
            ++state_count;
            s.generate(out, offset + 2);
        }
        return state_count;
    }

    @Override
    public String getStmtBody() {
        return "<<VHDLFor>>";
    }

    @Override
    public void generate(PrintWriter out, int offset) {
        int state_count = 1;
        int loop_state_count = 0;
        this.writeln(out, String.format("case conv_integer(%s) is", this.STATE_SIG.value()), offset);
        this.writeln(out, String.format("when 0 => %s <= %s + 1;", this.STATE_SIG.value(), this.STATE_SIG.value()), offset + 2);
        state_count = this.genConditionPrepare(out, offset + 2);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        ++state_count;
        for (VHDLStatement stmt : this.init) {
            stmt.generate(out, offset + 4);
        }
        this.writeln(out, String.format("%s <= %s + 1;", this.get_state_sig().value(), this.get_state_sig().value()), offset + 4);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        loop_state_count = state_count++;
        this.writeln(out, String.format("if (%s) then", this.cond.getExprAsStr()), offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.get_state_sig().value(), this.get_state_sig().value()), offset + 6);
        if (this.body instanceof VHDLBlock && !this.process.isRaw()) {
            this.writeln(out, String.format("%s <= conv_std_logic_vector(1, %s'length);", ((VHDLBlock)this.body).STATE_SIG.value(), ((VHDLBlock)this.body).STATE_SIG.value()), offset + 6);
        }
        this.writeln(out, "else", offset + 4);
        this.writeln(out, String.format("%s <= %s + 1;", this.parent.get_state_sig().value(), this.parent.get_state_sig().value()), offset + 6);
        this.writeln(out, String.format("%s <= (others => '0');", this.STATE_SIG.value()), offset + 6);
        this.writeln(out, "end if;", offset + 4);
        this.writeln(out, String.format("when %d =>", state_count), offset + 2);
        this.body.generate(out, offset + 4);
        this.writeln(out, String.format("when %d =>", ++state_count), offset + 2);
        ++state_count;
        for (VHDLStatement stmt : this.step) {
            stmt.generate(out, offset + 6);
        }
        this.writeln(out, String.format("%s <= conv_std_logic_vector(%d, 32);", this.STATE_SIG.value(), loop_state_count), offset + 6);
        this.writeln(out, String.format("when others => %s <= (others => '0');", this.STATE_SIG.value()), offset + 2);
        this.writeln(out, "end case;", offset);
    }

    @Override
    public boolean isSkip() {
        return false;
    }

    @Override
    public ArrayList<VHDLIdent> getDestIdent() {
        ArrayList<VHDLIdent> l;
        ArrayList<VHDLIdent> l2;
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        if (this.cond != null && (l2 = this.cond.getDestIdent()) != null) {
            l2.addAll(l2);
        }
        if (this.body != null && (l2 = this.body.getDestIdent()) != null) {
            l2.addAll(l2);
        }
        for (VHDLStatement stmt : this.init) {
            l = stmt.getDestIdent();
            if (l == null) continue;
            list.addAll(l);
        }
        for (VHDLStatement stmt : this.step) {
            l = stmt.getDestIdent();
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    @Override
    public ArrayList<VHDLIdent> getSrcIdent() {
        ArrayList<VHDLIdent> l;
        ArrayList<VHDLIdent> l2;
        ArrayList<VHDLIdent> list = new ArrayList<VHDLIdent>();
        if (this.cond != null && (l2 = this.cond.getSrcIdent()) != null) {
            l2.addAll(l2);
        }
        if (this.body != null && (l2 = this.body.getSrcIdent()) != null) {
            l2.addAll(l2);
        }
        for (VHDLStatement stmt : this.init) {
            l = stmt.getSrcIdent();
            if (l == null) continue;
            list.addAll(l);
        }
        for (VHDLStatement stmt : this.step) {
            l = stmt.getSrcIdent();
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    @Override
    public void optimize() {
        if (this.body != null && this.body instanceof VHDLScope) {
            ((VHDLScope)this.body).optimize();
        }
    }
}

