library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;
entity BlockROM is
  generic (
    WIDTH : integer := 8;
    DEPTH : integer := 10);
  port (
    clka : in std_logic;
    dina : in std_logic_vector(WIDTH-1 downto 0);
    addra : in std_logic_vector(DEPTH-1 downto 0);
    wea : in std_logic_vector(0 downto 0);
    clkb : in std_logic;
    addrb : in std_logic_vector(DEPTH-1 downto 0);
    doutb : out std_logic_vector(WIDTH-1 downto 0)
    );
end BlockROM;

architecture syn of BlockROM is
  signal outb : std_logic_vector(7 downto 0);
begin
  doutb <= outb;
  process (clkb)
  begin
    case conv_integer(addrb) is
when 0 => outb <= "00101011";
when 1 => outb <= "00101011";
when 2 => outb <= "00101011";
when 3 => outb <= "00101011";
when 4 => outb <= "00101011";
when 5 => outb <= "00101011";
when 6 => outb <= "00101011";
when 7 => outb <= "00101011";
when 8 => outb <= "00101011";
when 9 => outb <= "00101011";
when 10 => outb <= "01011011";
when 11 => outb <= "00111110";
when 12 => outb <= "00101011";
when 13 => outb <= "00101011";
when 14 => outb <= "00101011";
when 15 => outb <= "00101011";
when 16 => outb <= "00101011";
when 17 => outb <= "00101011";
when 18 => outb <= "00101011";
when 19 => outb <= "00101011";
when 20 => outb <= "00101011";
when 21 => outb <= "00101011";
when 22 => outb <= "00111100";
when 23 => outb <= "00101101";
when 24 => outb <= "01011101";
when 25 => outb <= "00111110";
when 26 => outb <= "00101011";
when 27 => outb <= "00101011";
when 28 => outb <= "00101011";
when 29 => outb <= "00101011";
when 30 => outb <= "00101110";
when 31 => outb <= "00101011";
when 32 => outb <= "00101011";
when 33 => outb <= "00101011";
when 34 => outb <= "00101011";
when 35 => outb <= "00101011";
when 36 => outb <= "00101011";
when 37 => outb <= "00101011";
when 38 => outb <= "00101110";
when 39 => outb <= "00101101";
when 40 => outb <= "00101101";
when 41 => outb <= "00101101";
when 42 => outb <= "00101101";
when 43 => outb <= "00101101";
when 44 => outb <= "00101101";
when 45 => outb <= "00101101";
when 46 => outb <= "00101101";
when 47 => outb <= "00101110";
when 48 => outb <= "00101101";
when 49 => outb <= "00101101";
when 50 => outb <= "00101110";
      when others => null;
    end case;
  end process;
end syn;
