library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bf_sim is
end bf_sim;

architecture RTL of bf_sim is

  component bf is
    generic (
      ADDR_LENGTH : integer := 10);
    port (
      pClk   : in std_logic;
      pReset : in std_logic;
      pStdOut : out std_logic_VECTOR(7 downto 0)
      );
  end component;

  signal clk : std_logic := '0';
  signal stdout_data : std_logic_VECTOR(7 downto 0);
  
begin  -- RTL


  U0 : bf port map (
    pClk   => clk,
    pReset => '0',
    pStdOut => stdout_data
    );

  process
  begin
    clk <= not clk;
    wait for 20ns;
  end process;
  
end RTL;
