library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;

entity bf is
  
  generic (
    ADDR_LENGTH : integer := 10);

  port (
    pClk   : in std_logic;
    pReset : in std_logic;
    pStdOut : out std_logic_vector(7 downto 0)
    );

end bf;

architecture RTL of bf is

  type state_t is (IDLE, EXEC, WB, WB_0, WB_1, FORWARD_BLACKET, BACKWARD_BLACKET, RD);
  signal state : state_t := IDLE;

  component BlockRam
    generic (
      WIDTH : integer := 8;
      DEPTH : integer := 9);
    port (
      clka: IN std_logic;
      dina: IN std_logic_VECTOR(WIDTH-1 downto 0);
      addra: IN std_logic_VECTOR(DEPTH-1 downto 0);
      wea: IN std_logic_VECTOR(0 downto 0);
      clkb: IN std_logic;
      addrb: IN std_logic_VECTOR(DEPTH-1 downto 0);
      doutb: OUT std_logic_VECTOR(WIDTH-1 downto 0)
      );
  end component;

  component BlockRom
    generic (
      WIDTH : integer := 8;
      DEPTH : integer := 9);
    port (
      clka: IN std_logic;
      dina: IN std_logic_VECTOR(WIDTH-1 downto 0);
      addra: IN std_logic_VECTOR(DEPTH-1 downto 0);
      wea: IN std_logic_VECTOR(0 downto 0);
      clkb: IN std_logic;
      addrb: IN std_logic_VECTOR(DEPTH-1 downto 0);
      doutb: OUT std_logic_VECTOR(WIDTH-1 downto 0)
      );
  end component;

  signal iptr : std_logic_vector(ADDR_LENGTH-1 downto 0) := (others => '0');
  signal idata : std_logic_vector(7 downto 0) := (others => '0');

  signal dptr : std_logic_vector(ADDR_LENGTH-1 downto 0) := (others => '0');
  signal ddata_in : std_logic_vector(7 downto 0) := (others => '0');
  signal ddata_out : std_logic_vector(7 downto 0) := (others => '0');
  signal dWe : std_logic_vector(0 downto 0) := (others => '0');

  signal Z8 : std_logic_vector(7 downto 0) := (others => 'Z');
  signal Z10 : std_logic_vector(ADDR_LENGTH-1 downto 0) := (others => 'Z');

begin  -- RTL

  U0 : BlockRom
    generic map (
      WIDTH => 8,
      DEPTH => ADDR_LENGTH)
    port map (
      clka  => pClk,
      dina  => Z8,
      addra => Z10,
      wea   => "0",
      clkb  => pClk,
      addrb => iptr,
      doutb => idata);

  U1 : BlockRam
    generic map (
      WIDTH => 8,
      DEPTH => ADDR_LENGTH)
    port map (
      clka  => pClk,
      dina  => ddata_in,
      addra => dptr,
      wea   => dWe,
      clkb  => pClk,
      addrb => dptr,
      doutb => ddata_out);

  Z8 <= (others => 'Z');
  Z10 <= (others => 'Z');

  process (pClk, pReset)
  begin  -- process
    if pReset = '1' then
      
    elsif pClk'event and pClk = '1' then  -- rising clock edge
      case state is
        when IDLE =>
          state <= EXEC;
          iptr <= (others => '0');
          dptr <= (others => '0');
          ddata_in <= (others => '0');
          dWe <= (others => '0');
        when EXEC =>
          case conv_integer(idata) is
            when 62 =>  -- ?>62
              dptr <= dptr + '1';
              iptr <= iptr + '1';
              state <= RD;
            when 60 =>  -- ?<60
              dptr <= dptr - '1';
              iptr <= iptr + '1';
              state <= RD;
            when 43 =>  -- ?+43
              ddata_in <= ddata_out + '1';
              iptr <= iptr + '1';
              state <= WB;
            when 45 =>  -- ?-45
              ddata_in <= ddata_out - '1';
              iptr <= iptr + '1';
              state <= WB;
            when 46 =>  -- ?.46
              pStdOut <= ddata_out;
              iptr <= iptr + '1';
            when 44 =>  -- ?,44
              iptr <= iptr + '1';
              state <= EXEC;
            when 91 =>  -- ?\[91
              iptr <= iptr + '1';
              if conv_integer(ddata_out) = 0 then
                state <= FORWARD_BLACKET;
              else
                state <= EXEC;
              end if;
            when 93 =>  -- ?\]93
              state <= BACKWARD_BLACKET;
              iptr <= iptr - '1';
            when others =>
              state <= EXEC;
          end case;
        when WB =>
          state <= WB_0;
          dWe <= "1";
        when WB_0 =>
          state <= WB_1;
          dWe <= "0";
        when WB_1 =>
          state <= EXEC;
        when FORWARD_BLACKET =>
          iptr <= iptr + '1';
          if conv_integer(idata) = 93 then   -- ?\]91
            state <= EXEC;
          else
            state <= FORWARD_BLACKET;
          end if;
        when BACKWARD_BLACKET =>
          if conv_integer(idata) = 91 then   -- ?\[91
            state <= EXEC;
          else
            iptr <= iptr - '1';
            state <= BACKWARD_BLACKET;
          end if;
        when RD =>
          state <= EXEC;
        when others =>
          state <= IDLE;
      end case;
      
    end if;
  end process;
  
end RTL;
